/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.github.sardine.DavResource;
import com.github.sardine.impl.SardineException;
import com.github.sardine.util.SardineUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public class DAVMetadataFeature
implements Headers {
    private static final Logger log = LogManager.getLogger(DAVMetadataFeature.class);
    private final DAVSession session;

    public DAVMetadataFeature(DAVSession session) {
        this.session = session;
    }

    public Map<String, String> getDefault(Local local) {
        return new HostPreferences(this.session.getHost()).getMap("webdav.metadata.default");
    }

    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        try {
            List resources = ((DAVClient)((Object)this.session.getClient())).list(new DAVPathEncoder().encode(file), 0);
            Iterator iterator = resources.iterator();
            if (iterator.hasNext()) {
                DavResource resource = (DavResource)iterator.next();
                return resource.getCustomProps();
            }
            return Collections.emptyMap();
        }
        catch (SardineException e) {
            try {
                throw new DAVExceptionMappingService().map("Failure to read attributes of {0}", e, file);
            }
            catch (InteroperabilityException | NotfoundException i) {
                log.warn(String.format("Failure to obtain attributes of %s. %s", file, i));
                return Collections.emptyMap();
            }
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e, file);
        }
    }

    public void setMetadata(Path file, TransferStatus status) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Write metadata %s for file %s", status, file));
        }
        try {
            ArrayList<Element> props = new ArrayList<Element>();
            for (Map.Entry entry : status.getMetadata().entrySet()) {
                Element element = SardineUtil.createElement((QName)new QName("SAR:", (String)entry.getKey(), "s"));
                element.setTextContent((String)entry.getValue());
                props.add(element);
            }
            if (this.session.getFeature(Lock.class) != null && status.getLockId() != null) {
                ((DAVClient)((Object)this.session.getClient())).patch(new DAVPathEncoder().encode(file), props, Collections.emptyList(), Collections.singletonMap("If", String.format("(<%s>)", status.getLockId())));
            } else {
                ((DAVClient)((Object)this.session.getClient())).patch(new DAVPathEncoder().encode(file), props, Collections.emptyList());
            }
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e, file);
        }
    }
}

