/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.dav.DAVAttributesFinderFeature;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.dav.DAVTimestampFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import com.github.sardine.DavResource;
import com.github.sardine.impl.SardineException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DAVListService
implements ListService {
    private static final Logger log = LogManager.getLogger(DAVListService.class);
    private final DAVSession session;
    private final DAVAttributesFinderFeature attributes;

    public DAVListService(DAVSession session) {
        this(session, new DAVAttributesFinderFeature(session));
    }

    public DAVListService(DAVSession session, DAVAttributesFinderFeature attributes) {
        this.session = session;
        this.attributes = attributes;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList children = new AttributedList();
            for (DavResource resource : this.list(directory)) {
                String href = PathNormalizer.normalize((String)resource.getHref().getPath(), (boolean)true);
                if (href.equals(directory.getAbsolute())) {
                    log.warn(String.format("Ignore resource %s", href));
                    if (resource.isDirectory()) continue;
                    throw new NotfoundException(directory.getAbsolute());
                }
                PathAttributes attr = this.attributes.toAttributes(resource);
                Path file = new Path(directory, PathNormalizer.name((String)href), resource.isDirectory() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file), attr);
                children.add((Referenceable)file);
                listener.chunk(directory, children);
            }
            return children;
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e, directory);
        }
    }

    protected List<DavResource> list(Path directory) throws IOException {
        return ((DAVClient)((Object)this.session.getClient())).list(new DAVPathEncoder().encode(directory), 1, Stream.of(DAVTimestampFeature.LAST_MODIFIED_CUSTOM_NAMESPACE, DAVTimestampFeature.LAST_MODIFIED_SERVER_CUSTOM_NAMESPACE).collect(Collectors.toSet()));
    }
}

