/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import com.jamesmurty.utils.XMLBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class OwnershipControlsConfig {
    private List<Rule> rules = new ArrayList<Rule>();

    public List<Rule> getRules() {
        return this.rules;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public String toXml() throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder builder = XMLBuilder.create((String)"OwnershipControls");
        for (Rule rule : this.getRules()) {
            builder.elem("Rule").t(rule.ownership.textValue);
        }
        return builder.asString();
    }

    public class Rule {
        protected ObjectOwnership ownership;

        public ObjectOwnership getOwnership() {
            return this.ownership;
        }

        public void setOwnership(ObjectOwnership ownership) {
            this.ownership = ownership;
        }
    }

    public static enum ObjectOwnership {
        BUCKET_OWNER_PREFERRED("BucketOwnerPreferred"),
        OBJECT_WRITER("ObjectWriter"),
        BUCKET_OWNER_ENFORCED("BucketOwnerEnforced");

        private final String textValue;

        private ObjectOwnership(String textValue) {
            this.textValue = textValue;
        }

        public String toText() {
            return this.textValue;
        }

        public static ObjectOwnership fromText(String text) {
            for (ObjectOwnership e : ObjectOwnership.values()) {
                if (!e.toText().equalsIgnoreCase(text)) continue;
                return e;
            }
            throw new IllegalArgumentException("Invalid ObjectOwnership: " + text);
        }
    }
}

