/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import com.jamesmurty.utils.BaseXMLBuilder;
import com.jamesmurty.utils.XMLBuilder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.CloudFrontXmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.JetS3tRequestAuthorizer;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.cloudfront.CacheBehavior;
import org.jets3t.service.model.cloudfront.CustomOrigin;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.Invalidation;
import org.jets3t.service.model.cloudfront.InvalidationList;
import org.jets3t.service.model.cloudfront.InvalidationSummary;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.model.cloudfront.Origin;
import org.jets3t.service.model.cloudfront.OriginAccessIdentity;
import org.jets3t.service.model.cloudfront.OriginAccessIdentityConfig;
import org.jets3t.service.model.cloudfront.S3Origin;
import org.jets3t.service.model.cloudfront.StreamingDistribution;
import org.jets3t.service.model.cloudfront.StreamingDistributionConfig;
import org.jets3t.service.security.EncryptionUtil;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;

public class CloudFrontService
implements JetS3tRequestAuthorizer {
    private static final Log log = LogFactory.getLog(CloudFrontService.class);
    public static final String ENDPOINT = "https://cloudfront.amazonaws.com/";
    public static final String VERSION = "2012-05-05";
    public static final String XML_NAMESPACE = "http://cloudfront.amazonaws.com/doc/2012-05-05/";
    public static final String DEFAULT_BUCKET_SUFFIX = ".s3.amazonaws.com";
    public static final String ORIGIN_ACCESS_IDENTITY_URI_PATH = "/origin-access-identity/cloudfront";
    public static final String ORIGIN_ACCESS_IDENTITY_PREFIX = "origin-access-identity/cloudfront/";
    protected HttpClient httpClient;
    private CredentialsProvider credentialsProvider;
    private ProviderCredentials credentials;
    protected Jets3tProperties jets3tProperties;
    private String invokingApplicationDescription;
    protected int internalErrorRetryMax = 5;
    protected long timeOffset = 0L;

    public CloudFrontService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) {
        this.credentials = credentials;
        this.invokingApplicationDescription = invokingApplicationDescription;
        this.credentialsProvider = credentialsProvider;
        if (jets3tProperties == null) {
            jets3tProperties = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME);
        }
        this.jets3tProperties = jets3tProperties;
        this.internalErrorRetryMax = jets3tProperties.getIntProperty("cloudfront-service.internal-error-retry-max", 5);
        this.initializeDefaults();
    }

    protected void initializeDefaults() {
        System.setProperty("networkaddress.cache.ttl", "300");
        System.setProperty("networkaddress.cache.negative.ttl", "1");
        this.httpClient = this.initHttpClientBuilder().build();
    }

    protected HttpClientBuilder initHttpClientBuilder() {
        return RestUtils.initHttpClientBuilder(this, this.jets3tProperties, this.invokingApplicationDescription, this.credentialsProvider);
    }

    protected void initializeProxy(HttpClientBuilder httpClientBuilder) {
        if (this.jets3tProperties.getBoolProperty("httpclient.proxy-autodetect", true)) {
            RestUtils.initHttpProxy(httpClientBuilder, this.jets3tProperties);
        } else {
            String proxyHostAddress = this.jets3tProperties.getStringProperty("httpclient.proxy-host", null);
            int proxyPort = this.jets3tProperties.getIntProperty("httpclient.proxy-port", -1);
            String proxyUser = this.jets3tProperties.getStringProperty("httpclient.proxy-user", null);
            String proxyPassword = this.jets3tProperties.getStringProperty("httpclient.proxy-password", null);
            String proxyDomain = this.jets3tProperties.getStringProperty("httpclient.proxy-domain", null);
            RestUtils.initHttpProxy(httpClientBuilder, this.jets3tProperties, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain);
        }
    }

    public CloudFrontService(ProviderCredentials credentials) {
        this(credentials, null, null, null);
    }

    public ProviderCredentials getAWSCredentials() {
        return this.credentials;
    }

    protected Date getCurrentTimeWithOffset() {
        return new Date(System.currentTimeMillis() + this.timeOffset);
    }

    @Override
    public void authorizeHttpRequest(String bucketName, HttpUriRequest httpMethod, HttpContext context, String ignoredForceRequestSignatureVersion) throws ServiceException {
        String date = ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset());
        httpMethod.setHeader("Date", date);
        String signature = ServiceUtils.signWithHmacSha1(this.getAWSCredentials().getSecretKey(), date);
        String authorizationString = "AWS " + this.getAWSCredentials().getAccessKey() + ":" + signature;
        httpMethod.setHeader("Authorization", authorizationString);
    }

    protected HttpResponse performRestRequest(HttpRequestBase httpMethod, int expectedResponseCode) throws CloudFrontServiceException {
        if (httpMethod.getFirstHeader("Date") == null) {
            httpMethod.setHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        }
        HttpResponse response = null;
        int internalErrorCount = 0;
        try {
            boolean completedWithoutRecoverableError;
            do {
                completedWithoutRecoverableError = true;
                this.authorizeHttpRequest(null, (HttpUriRequest)httpMethod, null, null);
                response = this.httpClient.execute((HttpUriRequest)httpMethod);
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode == expectedResponseCode) continue;
                if (responseCode == 500) {
                    long delayMs = 1000L;
                    if (++internalErrorCount < this.internalErrorRetryMax) {
                        log.warn((Object)("Encountered " + internalErrorCount + " CloudFront Internal Server error(s), will retry in " + delayMs + "ms"));
                        Thread.sleep(delayMs);
                        completedWithoutRecoverableError = false;
                        continue;
                    }
                    throw new CloudFrontServiceException("Encountered too many CloudFront Internal Server errors (" + internalErrorCount + "), aborting request.");
                }
                CloudFrontXmlResponsesSaxParser.ErrorHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseErrorResponse(response.getEntity().getContent());
                CloudFrontServiceException exception = new CloudFrontServiceException("Request failed with CloudFront Service error", responseCode, handler.getType(), handler.getCode(), handler.getMessage(), handler.getDetail(), handler.getRequestId());
                if ("RequestExpired".equals(exception.getErrorCode())) {
                    this.timeOffset = RestUtils.calculateTimeAdjustmentOffset(response);
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Adjusted time offset in response to RequestTimeTooSkewed error. Local machine and service disagree on the time by approximately " + this.timeOffset / 1000L + " seconds, please fix your system's time. Retrying connection."));
                    }
                    completedWithoutRecoverableError = false;
                    continue;
                }
                throw exception;
            } while (!completedWithoutRecoverableError);
        }
        catch (CloudFrontServiceException e) {
            this.releaseConnection(response);
            throw e;
        }
        catch (Exception t) {
            this.releaseConnection(response);
            throw new CloudFrontServiceException("CloudFront Request failed", t);
        }
        return response;
    }

    private void releaseConnection(HttpResponse pResponse) {
        if (pResponse == null) {
            return;
        }
        try {
            EntityUtils.consume((HttpEntity)pResponse.getEntity());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected List<Distribution> listDistributionsImpl(boolean isStreaming, int pagingSize) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing " + (isStreaming ? "streaming" : "") + " distributions for AWS user: " + this.getAWSCredentials().getAccessKey()));
        }
        try {
            boolean incompleteListing;
            ArrayList<Distribution> distributions = new ArrayList<Distribution>();
            String nextMarker = null;
            do {
                String uri = "https://cloudfront.amazonaws.com/2012-05-05" + (isStreaming ? "/streaming-distribution" : "/distribution") + "?MaxItems=" + pagingSize;
                if (nextMarker != null) {
                    uri = uri + "&Marker=" + nextMarker;
                }
                HttpGet httpMethod = new HttpGet(uri);
                HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 200);
                CloudFrontXmlResponsesSaxParser.DistributionListHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionListResponse(response.getEntity().getContent());
                distributions.addAll(handler.getDistributions());
                incompleteListing = handler.isTruncated();
                nextMarker = handler.getNextMarker();
                if (!incompleteListing || nextMarker != null) continue;
                throw new CloudFrontServiceException("Unable to retrieve paginated DistributionList results without a valid NextMarker value.");
            } while (incompleteListing);
            return distributions;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Distribution[] listDistributions(int pagingSize) throws CloudFrontServiceException {
        List<Distribution> distributions = this.listDistributionsImpl(false, pagingSize);
        return distributions.toArray(new Distribution[distributions.size()]);
    }

    public StreamingDistribution[] listStreamingDistributions(int pagingSize) throws CloudFrontServiceException {
        List<Distribution> distributions = this.listDistributionsImpl(true, pagingSize);
        return distributions.toArray(new StreamingDistribution[distributions.size()]);
    }

    public Distribution[] listDistributions() throws CloudFrontServiceException {
        return this.listDistributions(100);
    }

    public StreamingDistribution[] listStreamingDistributions() throws CloudFrontServiceException {
        return this.listStreamingDistributions(100);
    }

    public List<Distribution> listDistributionsByBucketName(boolean isStreaming, String bucketName) throws CloudFrontServiceException {
        Distribution[] allDistributions;
        String s3Endpoint = this.jets3tProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_DEFAULT_HOSTNAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing " + (isStreaming ? "streaming" : "") + " distributions for the S3 bucket '" + bucketName + "' for AWS user: " + this.getAWSCredentials().getAccessKey()));
        }
        ArrayList<Distribution> bucketDistributions = new ArrayList<Distribution>();
        block0: for (Distribution distribution : allDistributions = isStreaming ? this.listStreamingDistributions() : this.listDistributions()) {
            for (Origin origin : distribution.getConfig().getOrigins()) {
                if (!(origin instanceof S3Origin) || !origin.getDomainName().equals(bucketName) && !bucketName.equals(ServiceUtils.findBucketNameInHostname(origin.getDomainName(), s3Endpoint))) continue;
                bucketDistributions.add(distribution);
                continue block0;
            }
        }
        return bucketDistributions;
    }

    public Distribution[] listDistributions(String bucketName) throws CloudFrontServiceException {
        List<Distribution> bucketDistributions = this.listDistributionsByBucketName(false, bucketName);
        return bucketDistributions.toArray(new Distribution[bucketDistributions.size()]);
    }

    public StreamingDistribution[] listStreamingDistributions(String bucketName) throws CloudFrontServiceException {
        List<Distribution> streamingDistributions = this.listDistributionsByBucketName(true, bucketName);
        return streamingDistributions.toArray(new StreamingDistribution[streamingDistributions.size()]);
    }

    protected XMLBuilder buildOrigin(Origin origin) throws TransformerException, ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder builder = XMLBuilder.create((String)"Origin");
        if (origin.getId() != null) {
            builder.e("Id").t(origin.getId());
        } else {
            builder.e("Id").t("default-origin-id");
        }
        if (origin instanceof S3Origin) {
            builder.e("DomainName").t(CloudFrontService.sanitizeS3BucketName(origin.getDomainName()));
            S3Origin o = (S3Origin)origin;
            XMLBuilder oaiBuilder = builder.e("S3OriginConfig").e("OriginAccessIdentity");
            if (o.getOriginAccessIdentity() != null) {
                oaiBuilder.t(o.getOriginAccessIdentity());
            }
        } else {
            CustomOrigin o = (CustomOrigin)origin;
            builder.e("DomainName").t(origin.getDomainName());
            builder.e("CustomOriginConfig").e("HTTPPort").t(String.valueOf(o.getHttpPort())).up().e("HTTPSPort").t(String.valueOf(o.getHttpsPort())).up().e("OriginProtocolPolicy").t(o.getOriginProtocolPolicy().toText());
        }
        return builder;
    }

    protected XMLBuilder buildTrustedSigners(String[] trustedSignerAwsAccountNumbers) throws ParserConfigurationException {
        XMLBuilder trustedSignersBuilder = XMLBuilder.create((String)"TrustedSigners");
        if (trustedSignerAwsAccountNumbers == null || trustedSignerAwsAccountNumbers.length == 0) {
            trustedSignersBuilder.e("Enabled").t(String.valueOf(false)).up().e("Quantity").t(String.valueOf(0));
        } else {
            XMLBuilder itemsBuilder = trustedSignersBuilder.e("Enabled").t(String.valueOf(true)).up().e("Quantity").t(String.valueOf(trustedSignerAwsAccountNumbers.length)).up().e("Items");
            for (String awsAccountNumber : trustedSignerAwsAccountNumbers) {
                itemsBuilder.e("AwsAccountNumber").t(awsAccountNumber);
            }
        }
        return trustedSignersBuilder;
    }

    protected XMLBuilder buildDefaultCacheBehavior(CacheBehavior cb) throws TransformerException, ParserConfigurationException, FactoryConfigurationError {
        return this.buildCacheBehaviorsElement(true, new CacheBehavior[]{cb});
    }

    protected XMLBuilder buildCacheBehaviors(CacheBehavior[] cbs) throws TransformerException, ParserConfigurationException, FactoryConfigurationError {
        return this.buildCacheBehaviorsElement(false, cbs);
    }

    protected XMLBuilder buildCacheBehaviorsElement(boolean isDefault, CacheBehavior[] cbs) throws TransformerException, ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder builder = isDefault ? XMLBuilder.create((String)"DefaultCacheBehavior") : XMLBuilder.create((String)"CacheBehaviors").e("Quantity").t(String.valueOf(cbs.length)).up();
        if (!isDefault && cbs.length > 0) {
            builder = builder.e("Items");
        }
        for (CacheBehavior cb : cbs) {
            XMLBuilder itemBuilder;
            if (isDefault) {
                itemBuilder = builder;
            } else {
                itemBuilder = builder.e("CacheBehavior");
                itemBuilder.e("PathPattern").t(cb.getPathPattern());
            }
            if (cb.getTargetOriginId() != null) {
                itemBuilder.e("TargetOriginId").t(cb.getTargetOriginId());
            } else {
                itemBuilder.e("TargetOriginId").t("default-origin-id");
            }
            itemBuilder.e("ForwardedValues").e("QueryString").t(String.valueOf(cb.isForwardQueryString()));
            itemBuilder.importXMLBuilder((BaseXMLBuilder)this.buildTrustedSigners(cb.getTrustedSignerAwsAccountNumbers()));
            itemBuilder.e("ViewerProtocolPolicy").t(cb.getViewerProtocolPolicy().toText());
            if (cb.getMinTTL() != null) {
                itemBuilder.e("MinTTL").t(String.valueOf(cb.getMinTTL()));
                continue;
            }
            itemBuilder.e("MinTTL").t(String.valueOf(0));
        }
        return builder;
    }

    protected String buildDistributionConfigXmlDocument(DistributionConfig config) throws TransformerException, ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder builder;
        block11: {
            block10: {
                builder = XMLBuilder.create((String)(config.isStreamingDistributionConfig() ? "StreamingDistributionConfig" : "DistributionConfig")).a("xmlns", XML_NAMESPACE);
                builder.e("CallerReference").t(config.getCallerReference() == null ? String.valueOf(System.currentTimeMillis()) : config.getCallerReference());
                XMLBuilder aliasesBuilder = builder.e("Aliases");
                if (config.getCNAMEs() != null && config.getCNAMEs().length > 0) {
                    aliasesBuilder.e("Quantity").t(String.valueOf(config.getCNAMEs().length));
                    XMLBuilder items = aliasesBuilder.e("Items");
                    for (String cname : config.getCNAMEs()) {
                        items.e("CNAME").t(cname);
                    }
                } else {
                    aliasesBuilder.e("Quantity").t(String.valueOf("0"));
                }
                if (config.getDefaultRootObject() != null) {
                    builder.e("DefaultRootObject").t(config.getDefaultRootObject());
                } else {
                    builder.e("DefaultRootObject");
                }
                if (!config.isStreamingDistributionConfig()) break block10;
                if (config.getOrigins().length != 1) break block11;
                S3Origin bucket = (S3Origin)config.getOrigins()[0];
                XMLBuilder origin = builder.e("S3Origin");
                origin.e("DomainName").t(CloudFrontService.sanitizeS3BucketName(bucket.getDomainName()));
                origin.e("OriginAccessIdentity");
                if (bucket.getOriginAccessIdentity() == null) break block11;
                origin.t(bucket.getOriginAccessIdentity());
                break block11;
            }
            XMLBuilder originsBuilder = builder.e("Origins").e("Quantity").t(String.valueOf(config.getOrigins().length)).up().e("Items");
            for (Origin origin : config.getOrigins()) {
                originsBuilder.importXMLBuilder((BaseXMLBuilder)this.buildOrigin(origin));
            }
        }
        if (config.isStreamingDistributionConfig()) {
            builder.importXMLBuilder((BaseXMLBuilder)this.buildTrustedSigners(config.getTrustedSignerAwsAccountNumbers()));
        } else {
            builder.importXMLBuilder((BaseXMLBuilder)this.buildDefaultCacheBehavior(config.getDefaultCacheBehavior()));
            builder.importXMLBuilder((BaseXMLBuilder)this.buildCacheBehaviors(config.getCacheBehaviors()));
        }
        builder.e("Comment").t(null == config.getComment() ? "" : config.getComment());
        if (config.getLoggingStatus() != null) {
            builder.e("Logging").e("Enabled").t(String.valueOf(true)).up().e("Bucket").t(config.getLoggingStatus().getBucket()).up().e("Prefix").t(config.getLoggingStatus().getPrefix());
        } else {
            builder.e("Logging").e("Enabled").t(String.valueOf(false)).up().e("Bucket").up().e("Prefix");
        }
        builder.e("Enabled").t(String.valueOf(config.isEnabled()));
        return builder.asString(null);
    }

    protected Distribution createDistributionImpl(DistributionConfig config) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating " + (config.isStreamingDistributionConfig() ? "streaming" : "") + " distribution for origins: " + Arrays.asList(config.getOrigins())));
        }
        HttpPost httpMethod = new HttpPost("https://cloudfront.amazonaws.com/2012-05-05" + (config.isStreamingDistributionConfig() ? "/streaming-distribution" : "/distribution"));
        try {
            String distributionConfigXml = this.buildDistributionConfigXmlDocument(config);
            httpMethod.setEntity((HttpEntity)new StringEntity(distributionConfigXml, ContentType.create((String)"text/xml", (String)Constants.DEFAULT_ENCODING)));
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 201);
            CloudFrontXmlResponsesSaxParser.DistributionHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionResponse(response.getEntity().getContent());
            return handler.getDistribution();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Distribution createDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws CloudFrontServiceException {
        return this.createDistribution(origin, callerReference, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject, null);
    }

    @Deprecated
    public Distribution createDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject, Long minTTL) throws CloudFrontServiceException {
        DistributionConfig config = new DistributionConfig(origin, callerReference, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject, minTTL);
        return this.createDistributionImpl(config);
    }

    public Distribution createDistribution(Origin origin) throws CloudFrontServiceException {
        return this.createDistribution(origin, null, null, null, true, null);
    }

    public Distribution createDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        return this.createDistribution(origin, callerReference, cnames, comment, enabled, loggingStatus, false, null, null, null);
    }

    public Distribution createDistribution(DistributionConfig config) throws CloudFrontServiceException {
        return this.createDistributionImpl(config);
    }

    @Deprecated
    public StreamingDistribution createStreamingDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers) throws CloudFrontServiceException {
        StreamingDistributionConfig config = new StreamingDistributionConfig(origin, callerReference, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, null);
        return (StreamingDistribution)this.createDistributionImpl(config);
    }

    @Deprecated
    public StreamingDistribution createStreamingDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        StreamingDistributionConfig config = new StreamingDistributionConfig(origin, callerReference, cnames, comment, enabled, loggingStatus);
        return (StreamingDistribution)this.createDistributionImpl(config);
    }

    protected Distribution getDistributionInfoImpl(boolean isStreaming, String distributionId) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting information for " + (isStreaming ? "streaming" : "") + " distribution with id: " + distributionId));
        }
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2012-05-05" + (isStreaming ? "/streaming-distribution/" : "/distribution/") + distributionId);
        try {
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionResponse(response.getEntity().getContent());
            return handler.getDistribution();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Distribution getDistributionInfo(String id) throws CloudFrontServiceException {
        return this.getDistributionInfoImpl(false, id);
    }

    public StreamingDistribution getStreamingDistributionInfo(String distributionId) throws CloudFrontServiceException {
        return (StreamingDistribution)this.getDistributionInfoImpl(true, distributionId);
    }

    protected DistributionConfig getDistributionConfigImpl(boolean isStreaming, String distributionId) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting configuration for " + (isStreaming ? "streaming" : "") + " distribution with id: " + distributionId));
        }
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2012-05-05" + (isStreaming ? "/streaming-distribution/" : "/distribution/") + distributionId + "/config");
        try {
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionConfigResponse(response.getEntity().getContent());
            DistributionConfig config = handler.getDistributionConfig();
            config.setEtag(response.getFirstHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public DistributionConfig getDistributionConfig(String distributionId) throws CloudFrontServiceException {
        return this.getDistributionConfigImpl(false, distributionId);
    }

    public StreamingDistributionConfig getStreamingDistributionConfig(String id) throws CloudFrontServiceException {
        return (StreamingDistributionConfig)this.getDistributionConfigImpl(true, id);
    }

    protected DistributionConfig updateDistributionConfigImpl(String id, DistributionConfig config) throws CloudFrontServiceException {
        String etag;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating configuration of " + (config.isStreamingDistributionConfig() ? "streaming" : "") + "distribution with id: " + id));
        }
        if (null == (etag = config.getEtag())) {
            DistributionConfig oldConfig = config.isStreamingDistributionConfig() ? this.getStreamingDistributionConfig(id) : this.getDistributionConfig(id);
            etag = oldConfig.getEtag();
        }
        HttpPut httpMethod = new HttpPut("https://cloudfront.amazonaws.com/2012-05-05" + (config.isStreamingDistributionConfig() ? "/streaming-distribution/" : "/distribution/") + id + "/config");
        try {
            String distributionConfigXml = this.buildDistributionConfigXmlDocument(config);
            httpMethod.setEntity((HttpEntity)new StringEntity(distributionConfigXml, ContentType.create((String)"text/xml", (String)Constants.DEFAULT_ENCODING)));
            httpMethod.setHeader("If-Match", etag);
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionConfigResponse(response.getEntity().getContent());
            DistributionConfig resultConfig = handler.getDistributionConfig();
            resultConfig.setEtag(response.getFirstHeader("ETag").getValue());
            return resultConfig;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    @Deprecated
    public DistributionConfig updateDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject, Long minTTL) throws CloudFrontServiceException {
        DistributionConfig config = new DistributionConfig(origin, null, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject, minTTL);
        return this.updateDistributionConfigImpl(id, config);
    }

    public DistributionConfig updateDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws CloudFrontServiceException {
        DistributionConfig config = new DistributionConfig(origin, null, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject, null);
        return this.updateDistributionConfigImpl(id, config);
    }

    @Deprecated
    public StreamingDistributionConfig updateStreamingDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        StreamingDistributionConfig config = new StreamingDistributionConfig(origin, null, cnames, comment, enabled, loggingStatus, false, null, null);
        return (StreamingDistributionConfig)this.updateDistributionConfigImpl(id, config);
    }

    @Deprecated
    public StreamingDistributionConfig updateStreamingDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers) throws CloudFrontServiceException {
        StreamingDistributionConfig config = new StreamingDistributionConfig(origin, null, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, null);
        return (StreamingDistributionConfig)this.updateDistributionConfigImpl(id, config);
    }

    public DistributionConfig updateDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        return this.updateDistributionConfig(id, origin, cnames, comment, enabled, loggingStatus, false, null, null, null);
    }

    public DistributionConfig updateDistributionConfig(String id, DistributionConfig config) throws CloudFrontServiceException {
        return this.updateDistributionConfigImpl(id, config);
    }

    public void disableDistributionForDeletion(String id) throws CloudFrontServiceException {
        this.updateDistributionConfig(id, null, new String[0], "Disabled prior to deletion", false, null);
    }

    public void disableStreamingDistributionForDeletion(String id) throws CloudFrontServiceException {
        this.updateStreamingDistributionConfig(id, null, new String[0], "Disabled prior to deletion", false, null);
    }

    protected void deleteDistributionImpl(boolean isStreaming, String distributionId) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting " + (isStreaming ? "streaming" : "") + "distribution with id: " + distributionId));
        }
        DistributionConfig currentConfig = isStreaming ? this.getStreamingDistributionConfig(distributionId) : this.getDistributionConfig(distributionId);
        HttpDelete httpMethod = new HttpDelete("https://cloudfront.amazonaws.com/2012-05-05" + (isStreaming ? "/streaming-distribution/" : "/distribution/") + distributionId);
        try {
            httpMethod.setHeader("If-Match", currentConfig.getEtag());
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 204);
            this.releaseConnection(response);
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public void deleteDistribution(String id) throws CloudFrontServiceException {
        this.deleteDistributionImpl(false, id);
    }

    public void deleteStreamingDistribution(String id) throws CloudFrontServiceException {
        this.deleteDistributionImpl(true, id);
    }

    public OriginAccessIdentity createOriginAccessIdentity(String callerReference, String comment) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating origin access identity");
        }
        HttpPost httpMethod = new HttpPost("https://cloudfront.amazonaws.com/2012-05-05/origin-access-identity/cloudfront");
        if (callerReference == null) {
            callerReference = String.valueOf(System.currentTimeMillis());
        }
        try {
            XMLBuilder builder = XMLBuilder.create((String)"CloudFrontOriginAccessIdentityConfig").a("xmlns", XML_NAMESPACE).e("CallerReference").t(callerReference).up().e("Comment").t(comment);
            httpMethod.setEntity((HttpEntity)new StringEntity(builder.asString(null), ContentType.create((String)"text/xml", (String)Constants.DEFAULT_ENCODING)));
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 201);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentity(response.getEntity().getContent());
            return handler.getOriginAccessIdentity();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public List<OriginAccessIdentity> getOriginAccessIdentityList() throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Getting list of origin access identities");
        }
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2012-05-05/origin-access-identity/cloudfront");
        try {
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityListHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentityListResponse(response.getEntity().getContent());
            return handler.getOriginAccessIdentityList();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public OriginAccessIdentity getOriginAccessIdentity(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting information for origin access identity with id: " + id));
        }
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2012-05-05/origin-access-identity/cloudfront/" + id);
        try {
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentity(response.getEntity().getContent());
            return handler.getOriginAccessIdentity();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public OriginAccessIdentityConfig getOriginAccessIdentityConfig(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting config for origin access identity with id: " + id));
        }
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2012-05-05/origin-access-identity/cloudfront/" + id + "/config");
        try {
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentityConfig(response.getEntity().getContent());
            OriginAccessIdentityConfig config = handler.getOriginAccessIdentityConfig();
            config.setEtag(response.getFirstHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public OriginAccessIdentityConfig updateOriginAccessIdentityConfig(String id, String comment) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating configuration of origin access identity with id: " + id));
        }
        OriginAccessIdentityConfig oldConfig = this.getOriginAccessIdentityConfig(id);
        if (comment == null) {
            comment = oldConfig.getComment();
        }
        HttpPut httpMethod = new HttpPut("https://cloudfront.amazonaws.com/2012-05-05/origin-access-identity/cloudfront/" + id + "/config");
        try {
            XMLBuilder builder = XMLBuilder.create((String)"CloudFrontOriginAccessIdentityConfig").a("xmlns", XML_NAMESPACE).e("CallerReference").t(oldConfig.getCallerReference()).up().e("Comment").t(comment);
            httpMethod.setEntity((HttpEntity)new StringEntity(builder.asString(null), ContentType.create((String)"text/xml", (String)Constants.DEFAULT_ENCODING)));
            httpMethod.setHeader("If-Match", oldConfig.getEtag());
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentityConfig(response.getEntity().getContent());
            OriginAccessIdentityConfig config = handler.getOriginAccessIdentityConfig();
            config.setEtag(response.getFirstHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public void deleteOriginAccessIdentity(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting origin access identity with id: " + id));
        }
        OriginAccessIdentityConfig currentConfig = this.getOriginAccessIdentityConfig(id);
        HttpDelete httpMethod = new HttpDelete("https://cloudfront.amazonaws.com/2012-05-05/origin-access-identity/cloudfront/" + id);
        try {
            httpMethod.setHeader("If-Match", currentConfig.getEtag());
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 204);
            this.releaseConnection(response);
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Invalidation invalidateObjects(String distributionId, String[] objectKeys, String callerReference) throws CloudFrontServiceException {
        HttpPost httpMethod = new HttpPost("https://cloudfront.amazonaws.com/2012-05-05/distribution/" + distributionId + "/invalidation");
        try {
            XMLBuilder builder = XMLBuilder.create((String)"InvalidationBatch");
            XMLBuilder paths = builder.e("Paths");
            paths.e("Quantity").t(String.valueOf(objectKeys.length));
            XMLBuilder items = paths.e("Items");
            for (String objectPath : objectKeys) {
                String encodedPath = RestUtils.encodeUrlPath(objectPath, "/");
                if (!encodedPath.startsWith("/")) {
                    encodedPath = "/" + encodedPath;
                }
                items.e("Path").t(encodedPath);
            }
            builder.e("CallerReference").t(callerReference);
            httpMethod.setEntity((HttpEntity)new StringEntity(builder.asString(null), ContentType.create((String)"text/xml", (String)Constants.DEFAULT_ENCODING)));
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 201);
            CloudFrontXmlResponsesSaxParser.InvalidationHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseInvalidationResponse(response.getEntity().getContent());
            return handler.getInvalidation();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Invalidation invalidateObjects(String distributionId, S3Object[] objects, String callerReference) throws CloudFrontServiceException {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.invalidateObjects(distributionId, objectKeys, callerReference);
    }

    public Invalidation getInvalidation(String distributionId, String invalidationId) throws CloudFrontServiceException {
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2012-05-05/distribution/" + distributionId + "/invalidation/" + invalidationId);
        try {
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.InvalidationHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseInvalidationResponse(response.getEntity().getContent());
            return handler.getInvalidation();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public InvalidationList listInvalidations(String distributionId, String nextMarker, int pagingSize) throws CloudFrontServiceException {
        try {
            String uri = "https://cloudfront.amazonaws.com/2012-05-05/distribution/" + distributionId + "/invalidation?MaxItems=" + pagingSize;
            if (nextMarker != null) {
                uri = uri + "&Marker=" + nextMarker;
            }
            HttpGet httpMethod = new HttpGet(uri);
            HttpResponse response = this.performRestRequest((HttpRequestBase)httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.InvalidationListHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseInvalidationListResponse(response.getEntity().getContent());
            return handler.getInvalidationList();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public List<InvalidationSummary> listInvalidations(String distributionId) throws CloudFrontServiceException {
        try {
            boolean incompleteListing;
            ArrayList<InvalidationSummary> invalidationSummaries = new ArrayList<InvalidationSummary>();
            String nextMarker = null;
            do {
                InvalidationList invalidationList = this.listInvalidations(distributionId, nextMarker, 100);
                invalidationSummaries.addAll(invalidationList.getInvalidationSummaries());
                incompleteListing = invalidationList.isTruncated();
                nextMarker = invalidationList.getNextMarker();
                if (!incompleteListing || nextMarker != null) continue;
                throw new CloudFrontServiceException("Unable to retrieve paginated InvalidationList results without a valid NextMarker value.");
            } while (incompleteListing);
            return invalidationSummaries;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public static String sanitizeS3BucketName(String proposedBucketName) {
        if (!proposedBucketName.endsWith(DEFAULT_BUCKET_SUFFIX)) {
            log.warn((Object)("Bucket names used within the CloudFront service should be specified as full S3 subdomain paths like 'jets3t.s3.amazonaws.com'. Repairing faulty bucket name value \"" + proposedBucketName + "\" by adding suffix '" + DEFAULT_BUCKET_SUFFIX + "'."));
            return proposedBucketName + DEFAULT_BUCKET_SUFFIX;
        }
        return proposedBucketName;
    }

    protected static String makeStringUrlSafe(String str) throws UnsupportedEncodingException {
        return ServiceUtils.toBase64(str.getBytes("UTF-8")).replace('+', '-').replace('=', '_').replace('/', '~');
    }

    protected static String makeBytesUrlSafe(byte[] bytes) throws UnsupportedEncodingException {
        return ServiceUtils.toBase64(bytes).replace('+', '-').replace('=', '_').replace('/', '~');
    }

    public static String buildPolicyForSignedUrl(String resourcePath, Date epochDateLessThan, String limitToIpAddressCIDR, Date epochDateGreaterThan) throws CloudFrontServiceException {
        if (epochDateLessThan == null) {
            throw new CloudFrontServiceException("epochDateLessThan must be provided to sign CloudFront URLs");
        }
        if (resourcePath == null) {
            resourcePath = "*";
        }
        String ipAddress = limitToIpAddressCIDR == null ? "0.0.0.0/0" : limitToIpAddressCIDR;
        return "{\"Statement\": [{\"Resource\":\"" + resourcePath + "\",\"Condition\":{\"DateLessThan\":{\"AWS:EpochTime\":" + epochDateLessThan.getTime() / 1000L + "},\"IpAddress\":{\"AWS:SourceIp\":\"" + ipAddress + "\"}" + (epochDateGreaterThan == null ? "" : ",\"DateGreaterThan\":{\"AWS:EpochTime\":" + epochDateGreaterThan.getTime() / 1000L + "}") + "}}]}";
    }

    public static String signUrl(String resourceUrlOrPath, String keyPairId, byte[] derPrivateKey, String policy) throws CloudFrontServiceException {
        try {
            byte[] signatureBytes = EncryptionUtil.signWithRsaSha1(derPrivateKey, policy.getBytes("UTF-8"));
            String urlSafePolicy = CloudFrontService.makeStringUrlSafe(policy);
            String urlSafeSignature = CloudFrontService.makeBytesUrlSafe(signatureBytes);
            return resourceUrlOrPath + (resourceUrlOrPath.indexOf(63) >= 0 ? "&" : "?") + "Policy=" + urlSafePolicy + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + keyPairId;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public static String signUrlCanned(String resourceUrlOrPath, String keyPairId, byte[] derPrivateKey, Date epochDateLessThan) throws CloudFrontServiceException {
        try {
            String cannedPolicy = "{\"Statement\":[{\"Resource\":\"" + resourceUrlOrPath + "\",\"Condition\":{\"DateLessThan\":{\"AWS:EpochTime\":" + epochDateLessThan.getTime() / 1000L + "}}}]}";
            byte[] signatureBytes = EncryptionUtil.signWithRsaSha1(derPrivateKey, cannedPolicy.getBytes("UTF-8"));
            String urlSafeSignature = CloudFrontService.makeBytesUrlSafe(signatureBytes);
            return resourceUrlOrPath + (resourceUrlOrPath.indexOf(63) >= 0 ? "&" : "?") + "Expires=" + epochDateLessThan.getTime() / 1000L + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + keyPairId;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }
}

