/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.date.RFC3339DateFormatter;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googledrive.DriveAttributesFinderFeature;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class DriveWriteFeature
extends AbstractHttpWriteFeature<File>
implements Write<File> {
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveWriteFeature(DriveSession session, DriveFileIdProvider fileid) {
        super((AttributesAdapter)new DriveAttributesFinderFeature(session, fileid));
        this.session = session;
        this.fileid = fileid;
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public boolean timestamp() {
        return true;
    }

    public HttpResponseOutputStream<File> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<File> command = new DelayedHttpEntityCallable<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public File call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    HttpPost request;
                    if (status.isExists()) {
                        String fileid = DriveWriteFeature.this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
                        request = new HttpPatch(String.format("%supload/drive/v3/files/%s?supportsAllDrives=true&fields=%s", ((Drive)DriveWriteFeature.this.session.getClient()).getRootUrl(), fileid, "createdTime,trashed,id,md5Checksum,mimeType,modifiedTime,name,size,webViewLink,shortcutDetails,version"));
                        if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
                            request.setHeader("Content-Type", status.getMime());
                        }
                        request.setEntity((HttpEntity)entity);
                    } else {
                        request = new HttpPost(String.format("%supload/drive/v3/files?uploadType=resumable&supportsAllDrives=%s&fields=%s", ((Drive)DriveWriteFeature.this.session.getClient()).getRootUrl(), new HostPreferences(DriveWriteFeature.this.session.getHost()).getBoolean("googledrive.teamdrive.enable"), "createdTime,trashed,id,md5Checksum,mimeType,modifiedTime,name,size,webViewLink,shortcutDetails,version"));
                        StringBuilder metadata = new StringBuilder("{");
                        metadata.append(String.format("\"name\":\"%s\"", file.getName()));
                        if (null != status.getTimestamp()) {
                            metadata.append(String.format(",\"modifiedTime\":\"%s\"", new RFC3339DateFormatter().format(status.getTimestamp().longValue(), TimeZone.getTimeZone("UTC"))));
                        }
                        if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
                            metadata.append(String.format(",\"mimeType\":\"%s\"", status.getMime()));
                        }
                        metadata.append(String.format(",\"parents\":[\"%s\"]", DriveWriteFeature.this.fileid.getFileId(file.getParent(), (ListProgressListener)new DisabledListProgressListener())));
                        metadata.append("}");
                        request.setEntity((HttpEntity)new StringEntity(metadata.toString(), ContentType.create((String)"application/json", (String)StandardCharsets.UTF_8.name())));
                        if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
                            request.addHeader("X-Upload-Content-Type", status.getMime());
                        }
                    }
                    request.addHeader("Content-Type", "application/json; charset=UTF-8");
                    HttpClient client = DriveWriteFeature.this.session.getHttpClient();
                    HttpResponse postResponse = client.execute((HttpUriRequest)request);
                    try {
                        switch (postResponse.getStatusLine().getStatusCode()) {
                            case 200: {
                                if (status.isExists()) {
                                    File file2 = (File)((Drive)DriveWriteFeature.this.session.getClient()).getObjectParser().parseAndClose((Reader)new InputStreamReader(postResponse.getEntity().getContent(), StandardCharsets.UTF_8), File.class);
                                    return file2;
                                }
                                break;
                            }
                            default: {
                                throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(postResponse.getStatusLine().getStatusCode(), postResponse.getStatusLine().getReasonPhrase()));
                            }
                        }
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)postResponse.getEntity());
                    }
                    if (status.isExists()) return null;
                    if (!postResponse.containsHeader("Location")) throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(postResponse.getStatusLine().getStatusCode(), postResponse.getStatusLine().getReasonPhrase()));
                    String putTarget = postResponse.getFirstHeader("Location").getValue();
                    HttpPut put = new HttpPut(putTarget);
                    put.setEntity((HttpEntity)entity);
                    HttpResponse putResponse = client.execute((HttpUriRequest)put);
                    try {
                        switch (putResponse.getStatusLine().getStatusCode()) {
                            case 200: 
                            case 201: {
                                File response = (File)((Drive)DriveWriteFeature.this.session.getClient()).getObjectParser().parseAndClose((Reader)new InputStreamReader(putResponse.getEntity().getContent(), StandardCharsets.UTF_8), File.class);
                                DriveWriteFeature.this.fileid.cache(file, response.getId());
                                File file3 = response;
                                return file3;
                            }
                        }
                        throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(putResponse.getStatusLine().getStatusCode(), putResponse.getStatusLine().getReasonPhrase()));
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)putResponse.getEntity());
                    }
                }
                catch (IOException e) {
                    throw new DriveExceptionMappingService(DriveWriteFeature.this.fileid).map("Upload {0} failed", e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }
}

