/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.ui.comparator.TimestampComparator;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.Revision;
import com.google.api.services.drive.model.RevisionList;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DriveVersioningFeature
implements Versioning {
    private static final Logger log = LogManager.getLogger(DriveVersioningFeature.class);
    protected static final String DEFAULT_FIELDS = String.format("revisions(%s),nextPageToken", "id,md5Checksum,modifiedTime,size,lastModifyingUser");
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveVersioningFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public VersioningConfiguration getConfiguration(Path container) {
        return new VersioningConfiguration(true);
    }

    public void setConfiguration(Path container, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        throw new UnsupportedException();
    }

    public void revert(Path file) throws BackgroundException {
        throw new UnsupportedException();
    }

    public boolean isRevertable(Path file) {
        return false;
    }

    public AttributedList<Path> list(Path file, ListProgressListener listener) throws BackgroundException {
        try {
            RevisionList list;
            AttributedList versions = new AttributedList();
            String page = null;
            do {
                list = (RevisionList)((Drive)this.session.getClient()).revisions().list(this.fileid.getFileId(file, listener)).setFields(DEFAULT_FIELDS).setPageSize(Integer.valueOf(new HostPreferences(this.session.getHost()).getInteger("googledrive.list.limit"))).setPageToken(page).execute();
                Iterator iter = list.getRevisions().iterator();
                while (iter.hasNext()) {
                    Revision revision = (Revision)iter.next();
                    if (!iter.hasNext() && revision.getMd5Checksum().equals(file.attributes().getChecksum().hash)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Found revision %s", revision));
                    }
                    versions.add((Referenceable)new Path(file).withAttributes(this.toAttributes(revision)));
                }
            } while ((page = list.getNextPageToken()) != null);
            return versions.filter((Comparator)new TimestampComparator(false));
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService(this.fileid).map("Failure to read attributes of {0}", e, file);
        }
    }

    private PathAttributes toAttributes(Revision f) {
        PathAttributes attributes = new PathAttributes();
        attributes.setSize(f.getSize().longValue());
        if (f.getModifiedTime() != null) {
            attributes.setModificationDate(f.getModifiedTime().getValue());
        }
        attributes.setChecksum(Checksum.parse((String)f.getMd5Checksum()));
        attributes.setVersionId(f.getId());
        attributes.setDuplicate(true);
        attributes.setOwner(f.getLastModifyingUser().getDisplayName());
        return attributes;
    }
}

