/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googledrive.DriveAttributesFinderFeature;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.Collections;

public class DriveTouchFeature
implements Touch<VersionId> {
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveTouchFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            Drive.Files.Create insert = ((Drive)this.session.getClient()).files().create(new File().setName(file.getName()).setMimeType(status.getMime()).setParents(Collections.singletonList(this.fileid.getFileId(file.getParent(), (ListProgressListener)new DisabledListProgressListener()))));
            File execute = (File)insert.setFields("createdTime,trashed,id,md5Checksum,mimeType,modifiedTime,name,size,webViewLink,shortcutDetails,version").setSupportsAllDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable"))).execute();
            this.fileid.cache(file, execute.getId());
            return file.withAttributes(new DriveAttributesFinderFeature(this.session, this.fileid).toAttributes(execute));
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService(this.fileid).map("Cannot create {0}", e, file);
        }
    }

    public DriveTouchFeature withWriter(Write<VersionId> writer) {
        return this;
    }

    public boolean isSupported(Path workdir, String filename) {
        if (workdir.isRoot()) {
            return false;
        }
        return !DriveHomeFinderService.SHARED_DRIVES_NAME.equals((Object)workdir);
    }
}

