/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.client.util.DateTime;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;

public class DriveTimestampFeature
extends DefaultTimestampFeature {
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveTimestampFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void setTimestamp(Path file, TransferStatus status) throws BackgroundException {
        try {
            String fileid = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
            File properties = new File();
            properties.setModifiedTime(new DateTime(status.getTimestamp().longValue()));
            ((Drive)this.session.getClient()).files().update(fileid, properties).setFields("modifiedTime").setSupportsAllDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable"))).execute();
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService(this.fileid).map("Failure to write attributes of {0}", e, file);
        }
    }
}

