/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Trash;
import ch.cyberduck.core.googledrive.DriveBatchTrashFeature;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.DriveTrashFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Map;

public class DriveThresholdTrashFeature
implements Trash {
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveThresholdTrashFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        if (files.size() == 1) {
            new DriveTrashFeature(this.session, this.fileid).delete(files, prompt, callback);
        } else {
            new DriveBatchTrashFeature(this.session, this.fileid).delete(files, prompt, callback);
        }
    }

    public boolean isRecursive() {
        return true;
    }
}

