/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.googledrive.DriveBatchDeleteFeature;
import ch.cyberduck.core.googledrive.DriveDeleteFeature;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Map;

public class DriveThresholdDeleteFeature
implements Delete {
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveThresholdDeleteFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        if (files.size() == 1) {
            new DriveDeleteFeature(this.session, this.fileid).delete(files, prompt, callback);
        } else {
            new DriveBatchDeleteFeature(this.session, this.fileid).delete(files, prompt, callback);
        }
    }

    public boolean isRecursive() {
        return true;
    }
}

