/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.TeamDrive;
import com.google.api.services.drive.model.TeamDriveList;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DriveTeamDrivesListService
implements ListService {
    private static final Logger log = LogManager.getLogger(DriveTeamDrivesListService.class);
    private final DriveSession session;
    private final DriveFileIdProvider fileid;
    private final int pagesize;

    public DriveTeamDrivesListService(DriveSession session, DriveFileIdProvider fileid) {
        this(session, fileid, 100);
    }

    public DriveTeamDrivesListService(DriveSession session, DriveFileIdProvider fileid, int pagesize) {
        this.session = session;
        this.fileid = fileid;
        this.pagesize = pagesize;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList children = new AttributedList();
            String page = null;
            do {
                TeamDriveList list = (TeamDriveList)((Drive)this.session.getClient()).teamdrives().list().setPageToken(page).setPageSize(Integer.valueOf(this.pagesize)).execute();
                for (TeamDrive f : list.getTeamDrives()) {
                    Path child = new Path(directory, f.getName(), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), new PathAttributes().withFileId(f.getId()));
                    children.add((Referenceable)child);
                }
                listener.chunk(directory, children);
                page = list.getNextPageToken();
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("Continue with next page token %s", page));
            } while (page != null);
            return children;
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService(this.fileid).map("Listing directory failed", e, directory);
        }
    }
}

