/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveSearchListService;
import ch.cyberduck.core.googledrive.DriveSession;

public class DriveSearchFeature
implements Search {
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveSearchFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        try {
            return new DriveSearchListService(this.session, this.fileid, regex.toPattern().pattern()).list(workdir, listener);
        }
        catch (NotfoundException e) {
            return AttributedList.emptyList();
        }
    }

    public boolean isRecursive() {
        return true;
    }
}

