/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.DriveUrlProvider;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.webloc.UrlFileWriterFactory;
import com.google.api.client.http.HttpHeaders;
import com.google.api.services.drive.Drive;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DriveReadFeature
implements Read {
    private static final Logger log = LogManager.getLogger(DriveReadFeature.class);
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveReadFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        Drive.Files.Get request;
        if (file.isPlaceholder()) {
            DescriptiveUrl link = new DriveUrlProvider().toUrl(file).find(DescriptiveUrl.Type.http);
            if (DescriptiveUrl.EMPTY.equals((Object)link)) {
                log.warn(String.format("Missing web link for file %s", file));
                return new NullInputStream(file.attributes().getSize());
            }
            return IOUtils.toInputStream((String)UrlFileWriterFactory.get().write(link), (Charset)Charset.defaultCharset());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType("application/json; charset=UTF-8");
        if (status.isAppend()) {
            HttpRange range = HttpRange.withStatus((TransferStatus)status);
            String header = -1L == range.getEnd() ? String.format("bytes=%d-", range.getStart()) : String.format("bytes=%d-%d", range.getStart(), range.getEnd());
            if (log.isDebugEnabled()) {
                log.debug(String.format("Add range header %s for file %s", header, file));
            }
            headers.setRange(header);
            headers.setAcceptEncoding("identity");
        }
        if (file.attributes().isDuplicate()) {
            try {
                request = ((Drive)this.session.getClient()).revisions().get(this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener()), file.attributes().getVersionId());
                request.setRequestHeaders(headers);
                return request.executeMediaAsInputStream();
            }
            catch (IOException e) {
                throw new DriveExceptionMappingService(this.fileid).map("Download {0} failed", e, file);
            }
        }
        try {
            try {
                request = ((Drive)this.session.getClient()).files().get(this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener()));
                request.setRequestHeaders(headers);
                request.setSupportsTeamDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable")));
                return request.executeMediaAsInputStream();
            }
            catch (IOException e) {
                throw new DriveExceptionMappingService(this.fileid).map("Download {0} failed", e, file);
            }
        }
        catch (RetriableAccessDeniedException e) {
            throw e;
        }
        catch (AccessDeniedException e) {
            if (!PreferencesFactory.get().getBoolean(String.format("connection.unsecure.download.%s", this.session.getHost().getHostname()))) {
                callback.warn(this.session.getHost(), MessageFormat.format(LocaleFactory.localizedString((String)"Download {0} failed", (String)"Error"), file.getName()), "Acknowledge the risk of downloading known malware or other abusive file.", LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), LocaleFactory.localizedString((String)"Cancel", (String)"Localizable"), String.format("connection.unsecure.download.%s", this.session.getHost().getHostname()));
            }
            try {
                Drive.Files.Get request2 = ((Drive)this.session.getClient()).files().get(this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener()));
                request2.setAcknowledgeAbuse(Boolean.valueOf(true));
                request2.setRequestHeaders(headers);
                request2.setSupportsTeamDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable")));
                return request2.executeMediaAsInputStream();
            }
            catch (IOException f) {
                throw new DriveExceptionMappingService(this.fileid).map("Download {0} failed", f, file);
            }
        }
    }
}

