/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.About;
import java.io.IOException;
import java.util.EnumSet;

public class DriveQuotaFeature
implements Quota {
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveQuotaFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Quota.Space get() throws BackgroundException {
        if (new DefaultHomeFinderService((Session)this.session).find().isChild(DriveHomeFinderService.SHARED_DRIVES_NAME)) {
            return unknown;
        }
        try {
            About about = (About)((Drive)this.session.getClient()).about().get().setFields("user, storageQuota").execute();
            Long used = null == about.getStorageQuota().getUsageInDrive() ? 0L : about.getStorageQuota().getUsageInDrive();
            Long available = (null == about.getStorageQuota().getLimit() ? Long.MAX_VALUE : about.getStorageQuota().getLimit()) - used;
            return new Quota.Space(used, available);
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService(this.fileid).map("Failure to read attributes of {0}", e, new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)));
        }
    }
}

