/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.googledrive.DriveAttributesFinderFeature;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.DriveTrashFeature;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DriveMoveFeature
implements Move {
    private static final Logger log = LogManager.getLogger(DriveMoveFeature.class);
    private final DriveSession session;
    private final DriveFileIdProvider fileid;
    private final Delete delete;

    public DriveMoveFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.delete = new DriveTrashFeature(session, fileid);
        this.fileid = fileid;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            if (status.isExists()) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Trash file %s to be replaced with %s", renamed, file));
                }
                this.delete.delete(Collections.singletonMap(renamed, status), (PasswordCallback)connectionCallback, callback);
            }
            String id = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
            File result = null;
            if (!StringUtils.equals((CharSequence)file.getName(), (CharSequence)renamed.getName())) {
                File properties = new File();
                properties.setName(renamed.getName());
                properties.setMimeType(status.getMime());
                result = (File)((Drive)this.session.getClient()).files().update(id, properties).setFields("createdTime,trashed,id,md5Checksum,mimeType,modifiedTime,name,size,webViewLink,shortcutDetails,version").setSupportsAllDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable"))).execute();
            }
            if (!file.getParent().equals((Object)renamed.getParent())) {
                StringBuilder previousParents = new StringBuilder();
                File reference = (File)((Drive)this.session.getClient()).files().get(id).setFields("parents").setSupportsAllDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable"))).execute();
                for (String parent : reference.getParents()) {
                    previousParents.append(parent).append(',');
                }
                result = (File)((Drive)this.session.getClient()).files().update(id, null).setAddParents(this.fileid.getFileId(renamed.getParent(), (ListProgressListener)new DisabledListProgressListener())).setRemoveParents(previousParents.toString()).setFields("createdTime,trashed,id,md5Checksum,mimeType,modifiedTime,name,size,webViewLink,shortcutDetails,version").setSupportsAllDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable"))).execute();
            }
            this.fileid.cache(file, null);
            this.fileid.cache(renamed, id);
            return renamed.withAttributes(new DriveAttributesFinderFeature(this.session, this.fileid).toAttributes(result));
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService(this.fileid).map("Cannot rename {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (target.isRoot()) {
            return false;
        }
        return !source.isPlaceholder();
    }
}

