/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public class DriveMetadataFeature
implements Metadata {
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveMetadataFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Map<String, String> getDefault(Local local) {
        return Collections.emptyMap();
    }

    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        try {
            String fileid = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
            Map properties = ((File)((Drive)this.session.getClient()).files().get(fileid).setFields("properties").setSupportsAllDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable"))).execute()).getProperties();
            if (null == properties) {
                return Collections.emptyMap();
            }
            return properties;
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService(this.fileid).map("Failure to read attributes of {0}", e, file);
        }
    }

    public void setMetadata(Path file, TransferStatus status) throws BackgroundException {
        try {
            String fileid = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
            File body = new File();
            body.setProperties(status.getMetadata());
            ((Drive)this.session.getClient()).files().update(fileid, body).setFields("properties").setSupportsAllDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable"))).execute();
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService(this.fileid).map("Failure to write attributes of {0}", e, file);
        }
    }
}

