/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.CachingFileIdProvider;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.FileIdProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.DriveTeamDrivesListService;
import ch.cyberduck.core.googledrive.FileidDriveListService;
import java.util.Comparator;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DriveFileIdProvider
extends CachingFileIdProvider
implements FileIdProvider {
    private static final Logger log = LogManager.getLogger(DriveFileIdProvider.class);
    private final DriveSession session;

    public DriveFileIdProvider(DriveSession session) {
        super(session.getCaseSensitivity());
        this.session = session;
    }

    public String getFileId(Path file, ListProgressListener listener) throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getFileId())) {
            return file.attributes().getFileId();
        }
        if (file.isRoot() || new SimplePathPredicate(file).test(DriveHomeFinderService.MYDRIVE_FOLDER) || new SimplePathPredicate(file).test(DriveHomeFinderService.SHARED_FOLDER_NAME) || new SimplePathPredicate(file).test(DriveHomeFinderService.SHARED_DRIVES_NAME)) {
            return "root";
        }
        String cached = super.getFileId(file, listener);
        if (cached != null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return cached fileid %s for file %s", cached, file));
            }
            return cached;
        }
        if (DriveHomeFinderService.SHARED_DRIVES_NAME.equals((Object)file.getParent())) {
            Path found = (Path)new DriveTeamDrivesListService(this.session, this).list(file.getParent(), listener).find((Predicate)new SimplePathPredicate(file));
            if (null == found) {
                throw new NotfoundException(file.getAbsolute());
            }
            return this.cache(file, found.attributes().getFileId());
        }
        Path query = file.isPlaceholder() ? new Path(file.getParent(), FilenameUtils.removeExtension((String)file.getName()), file.getType(), file.attributes()) : file;
        AttributedList<Path> list = new FileidDriveListService(this.session, this, query).list(file.getParent(), (ListProgressListener)new DisabledListProgressListener());
        Path found = (Path)list.filter((Comparator)new IgnoreTrashedComparator()).find((Predicate)new SimplePathPredicate(file));
        if (null == found) {
            throw new NotfoundException(file.getAbsolute());
        }
        return this.cache(file, found.attributes().getFileId());
    }

    private static final class IgnoreTrashedComparator
    implements Comparator<Path> {
        private IgnoreTrashedComparator() {
        }

        @Override
        public int compare(Path o1, Path o2) {
            return Boolean.compare(o1.attributes().isHidden(), o2.attributes().isDuplicate());
        }
    }
}

