/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googledrive.DriveAttributesFinderFeature;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.DriveTouchFeature;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.TeamDrive;
import java.io.IOException;
import java.util.Collections;

public class DriveDirectoryFeature
implements Directory<VersionId> {
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveDirectoryFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            if (DriveHomeFinderService.SHARED_DRIVES_NAME.equals((Object)folder.getParent())) {
                TeamDrive execute = (TeamDrive)((Drive)this.session.getClient()).teamdrives().create(new UUIDRandomStringService().random(), new TeamDrive().setName(folder.getName())).execute();
                return folder.withAttributes(new PathAttributes(folder.attributes()).withFileId(execute.getId()));
            }
            Drive.Files.Create insert = ((Drive)this.session.getClient()).files().create(new File().setName(folder.getName()).setMimeType("application/vnd.google-apps.folder").setParents(Collections.singletonList(this.fileid.getFileId(folder.getParent(), (ListProgressListener)new DisabledListProgressListener()))));
            File execute = (File)insert.setFields("createdTime,trashed,id,md5Checksum,mimeType,modifiedTime,name,size,webViewLink,shortcutDetails,version").setSupportsAllDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable"))).execute();
            this.fileid.cache(folder, execute.getId());
            return folder.withAttributes(new DriveAttributesFinderFeature(this.session, this.fileid).toAttributes(execute));
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService(this.fileid).map("Cannot create folder {0}", e, folder);
        }
    }

    public DriveDirectoryFeature withWriter(Write<VersionId> writer) {
        return this;
    }

    public boolean isSupported(Path workdir, String name) {
        return new DriveTouchFeature(this.session, this.fileid).isSupported(workdir, name);
    }
}

