/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DriveDeleteFeature
implements Delete {
    private static final Logger log = LogManager.getLogger(DriveDeleteFeature.class);
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveDeleteFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path f : files.keySet()) {
            if (f.isPlaceholder()) {
                log.warn(String.format("Ignore placeholder %s", f));
                continue;
            }
            callback.delete(f);
            try {
                if (DriveHomeFinderService.SHARED_DRIVES_NAME.equals((Object)f.getParent())) {
                    ((Drive)this.session.getClient()).teamdrives().delete(this.fileid.getFileId(f, (ListProgressListener)new DisabledListProgressListener())).execute();
                } else if (f.attributes().isDuplicate()) {
                    if (log.isWarnEnabled()) {
                        log.warn(String.format("Delete file %s already in trash", f));
                    }
                    ((Drive)this.session.getClient()).revisions().delete(this.fileid.getFileId(f, (ListProgressListener)new DisabledListProgressListener()), f.attributes().getVersionId()).execute();
                } else {
                    ((Drive)this.session.getClient()).files().delete(this.fileid.getFileId(f, (ListProgressListener)new DisabledListProgressListener())).setSupportsAllDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable"))).execute();
                }
                this.fileid.cache(f, null);
            }
            catch (IOException e) {
                throw new DriveExceptionMappingService(this.fileid).map("Cannot delete {0}", e, f);
            }
        }
    }

    public boolean isSupported(Path file) {
        if (file.isPlaceholder()) {
            return false;
        }
        return !file.getType().contains(AbstractPath.Type.shared);
    }

    public boolean isRecursive() {
        return true;
    }
}

