/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.googledrive.DriveAttributesFinderFeature;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.Collections;

public class DriveCopyFeature
implements Copy {
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveCopyFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        try {
            File copy = (File)((Drive)this.session.getClient()).files().copy(this.fileid.getFileId(source, (ListProgressListener)new DisabledListProgressListener()), new File().setParents(Collections.singletonList(this.fileid.getFileId(target.getParent(), (ListProgressListener)new DisabledListProgressListener()))).setName(target.getName())).setSupportsAllDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable"))).execute();
            listener.sent(status.getLength());
            this.fileid.cache(target, copy.getId());
            return target.withAttributes(new DriveAttributesFinderFeature(this.session, this.fileid).toAttributes(copy));
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService(this.fileid).map("Cannot copy {0}", e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (target.isRoot()) {
            return false;
        }
        return !source.isPlaceholder();
    }
}

