/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.collections.Partition;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Trash;
import ch.cyberduck.core.googledrive.DriveBatchDeleteFeature;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpHeaders;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.client.HttpResponseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DriveBatchTrashFeature
implements Trash {
    private static final Logger log = LogManager.getLogger(DriveBatchTrashFeature.class);
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveBatchTrashFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (List partition : new Partition(new ArrayList<Path>(files.keySet()), new HostPreferences(this.session.getHost()).getInteger("googledrive.delete.multiple.partition"))) {
            BatchRequest batch = ((Drive)this.session.getClient()).batch();
            CopyOnWriteArrayList<BackgroundException> failures = new CopyOnWriteArrayList<BackgroundException>();
            for (Path f : partition) {
                try {
                    if (DriveHomeFinderService.SHARED_DRIVES_NAME.equals((Object)f.getParent())) {
                        ((Drive)this.session.getClient()).teamdrives().delete(this.fileid.getFileId(f, (ListProgressListener)new DisabledListProgressListener())).queue(batch, new DeleteBatchCallback(f, failures, callback));
                        continue;
                    }
                    if (f.attributes().isHidden().booleanValue()) {
                        log.warn(String.format("Delete file %s already in trash", f));
                        new DriveBatchDeleteFeature(this.session, this.fileid).queue(f, batch, callback, failures);
                        continue;
                    }
                    File properties = new File();
                    properties.setTrashed(Boolean.valueOf(true));
                    ((Drive)this.session.getClient()).files().update(this.fileid.getFileId(f, (ListProgressListener)new DisabledListProgressListener()), properties).setSupportsAllDrives(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("googledrive.teamdrive.enable"))).queue(batch, new DeleteBatchCallback(f, failures, callback));
                }
                catch (IOException e) {
                    throw new DriveExceptionMappingService(this.fileid).map("Cannot delete {0}", e, f);
                }
            }
            if (partition.isEmpty()) continue;
            try {
                batch.execute();
            }
            catch (IOException e) {
                throw new DriveExceptionMappingService(this.fileid).map(e);
            }
            Iterator iterator = failures.iterator();
            if (!iterator.hasNext()) continue;
            BackgroundException e = (BackgroundException)iterator.next();
            throw e;
        }
    }

    public boolean isRecursive() {
        return true;
    }

    private class DeleteBatchCallback<V>
    extends JsonBatchCallback<V> {
        private final Path file;
        private final List<BackgroundException> failures;
        private final Delete.Callback callback;

        public DeleteBatchCallback(Path file, List<BackgroundException> failures, Delete.Callback callback) {
            this.file = file;
            this.failures = failures;
            this.callback = callback;
        }

        public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
            log.warn(String.format("Failure trashing %s. %s", this.file, e.getMessage()));
            this.failures.add(new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(e.getCode(), e.getMessage())));
        }

        public void onSuccess(V aVoid, HttpHeaders responseHeaders) {
            DriveBatchTrashFeature.this.fileid.cache(this.file, null);
            this.callback.delete(this.file);
        }
    }
}

