/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.googledrive.AbstractDriveListService;
import ch.cyberduck.core.googledrive.DriveFileIdProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.DriveTeamDrivesListService;
import ch.cyberduck.core.googledrive.FileidDriveListService;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.shared.ListFilteringFeature;
import ch.cyberduck.core.webloc.UrlFileWriterFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DriveAttributesFinderFeature
implements AttributesFinder,
AttributesAdapter<File> {
    private static final Logger log = LogManager.getLogger(DriveAttributesFinderFeature.class);
    protected static final String DEFAULT_FIELDS = "createdTime,trashed,id,md5Checksum,mimeType,modifiedTime,name,size,webViewLink,shortcutDetails,version";
    private final DriveSession session;
    private final DriveFileIdProvider fileid;

    public DriveAttributesFinderFeature(DriveSession session, DriveFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        if (new DefaultPathContainerService().isContainer(file)) {
            return PathAttributes.EMPTY;
        }
        Path query = file.isPlaceholder() ? new Path(file.getParent(), FilenameUtils.removeExtension((String)file.getName()), file.getType(), file.attributes()) : file;
        AttributedList<Path> list = DriveHomeFinderService.SHARED_DRIVES_NAME.equals((Object)file.getParent()) ? new DriveTeamDrivesListService(this.session, this.fileid).list(file.getParent(), listener) : new FileidDriveListService(this.session, this.fileid, query).list(file.getParent(), listener);
        Path found = (Path)list.find((Predicate)new ListFilteringFeature.ListFilteringPredicate(this.session.getCaseSensitivity(), file));
        if (null == found) {
            throw new NotfoundException(file.getAbsolute());
        }
        return found.attributes();
    }

    public PathAttributes toAttributes(File f) {
        if (AbstractDriveListService.DRIVE_SHORTCUT.equals(f.getMimeType())) {
            File.ShortcutDetails shortcutDetails = f.getShortcutDetails();
            try {
                return this.toAttributes((File)((Drive)this.session.getClient()).files().get(shortcutDetails.getTargetId()).setFields(DEFAULT_FIELDS).execute());
            }
            catch (IOException e) {
                log.warn(String.format("Failure %s resolving shortcut for %s", e, e));
                return PathAttributes.EMPTY;
            }
        }
        PathAttributes attributes = new PathAttributes();
        attributes.setFileId(f.getId());
        if (null != f.getTrashed() && f.getTrashed().booleanValue()) {
            attributes.setHidden(true);
        }
        if (null != f.getSize() && !AbstractDriveListService.DRIVE_FOLDER.equals(f.getMimeType()) && !StringUtils.startsWith((CharSequence)f.getMimeType(), (CharSequence)"application/vnd.google-apps")) {
            attributes.setSize(f.getSize().longValue());
        }
        if (f.getModifiedTime() != null) {
            attributes.setModificationDate(f.getModifiedTime().getValue());
        }
        if (f.getCreatedTime() != null) {
            attributes.setCreationDate(f.getCreatedTime().getValue());
        }
        attributes.setChecksum(Checksum.parse((String)f.getMd5Checksum()));
        if (StringUtils.isNotBlank((CharSequence)f.getWebViewLink())) {
            attributes.setLink(new DescriptiveUrl(URI.create(f.getWebViewLink()), DescriptiveUrl.Type.http, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), "HTTP")));
            if (!AbstractDriveListService.DRIVE_FOLDER.equals(f.getMimeType()) && !AbstractDriveListService.DRIVE_SHORTCUT.equals(f.getMimeType()) && StringUtils.startsWith((CharSequence)f.getMimeType(), (CharSequence)"application/vnd.google-apps")) {
                attributes.setSize((long)UrlFileWriterFactory.get().write(new DescriptiveUrl(URI.create(f.getWebViewLink()))).getBytes(Charset.defaultCharset()).length);
            }
        }
        return attributes;
    }
}

