/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.date.RFC3339DateFormatter;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class GoogleStorageWriteFeature
extends AbstractHttpWriteFeature<StorageObject>
implements Write<StorageObject> {
    private final PathContainerService containerService;
    private final GoogleStorageSession session;

    public GoogleStorageWriteFeature(GoogleStorageSession session) {
        super((AttributesAdapter)new GoogleStorageAttributesFinderFeature(session));
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public HttpResponseOutputStream<StorageObject> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<StorageObject> command = new DelayedHttpEntityCallable<StorageObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public StorageObject call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    uri = new StringBuilder(String.format("%supload/storage/v1/b/%s/o?uploadType=resumable", new Object[]{((Storage)GoogleStorageWriteFeature.access$000(GoogleStorageWriteFeature.this).getClient()).getRootUrl(), GoogleStorageWriteFeature.access$100(GoogleStorageWriteFeature.this).getContainer(file).getName()}));
                    if (!Acl.EMPTY.equals((Object)status.getAcl()) && status.getAcl().isCanned()) {
                        uri.append("&predefinedAcl=");
                        if (Acl.CANNED_PRIVATE.equals((Object)status.getAcl())) {
                            uri.append("private");
                        } else if (Acl.CANNED_PUBLIC_READ.equals((Object)status.getAcl())) {
                            uri.append("publicRead");
                        } else if (Acl.CANNED_PUBLIC_READ_WRITE.equals((Object)status.getAcl())) {
                            uri.append("publicReadWrite");
                        } else if (Acl.CANNED_AUTHENTICATED_READ.equals((Object)status.getAcl())) {
                            uri.append("authenticatedRead");
                        } else if (Acl.CANNED_BUCKET_OWNER_FULLCONTROL.equals((Object)status.getAcl())) {
                            uri.append("bucketOwnerFullControl");
                        } else if (Acl.CANNED_BUCKET_OWNER_READ.equals((Object)status.getAcl())) {
                            uri.append("bucketOwnerRead");
                        }
                        status.setAcl(Acl.EMPTY);
                    }
                    request = new HttpPost(uri.toString());
                    metadata = new StringBuilder();
                    metadata.append(String.format("{\"name\": \"%s\"", new Object[]{GoogleStorageWriteFeature.access$100(GoogleStorageWriteFeature.this).getKey(file)}));
                    metadata.append(",\"metadata\": {");
                    iter = status.getMetadata().entrySet().iterator();
                    while (iter.hasNext()) {
                        item = iter.next();
                        metadata.append(String.format("\"%s\": \"%s\"", new Object[]{item.getKey(), item.getValue()}));
                        if (!iter.hasNext()) continue;
                        metadata.append(",");
                    }
                    metadata.append("}");
                    if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
                        metadata.append(String.format(", \"contentType\": \"%s\"", new Object[]{status.getMime()}));
                    }
                    if (StringUtils.isNotBlank((CharSequence)status.getStorageClass())) {
                        metadata.append(String.format(", \"storageClass\": \"%s\"", new Object[]{status.getStorageClass()}));
                    }
                    if (null != status.getTimestamp()) {
                        metadata.append(String.format(", \"customTime\": \"%s\"", new Object[]{new RFC3339DateFormatter().format(status.getTimestamp().longValue(), TimeZone.getTimeZone("UTC"))}));
                    }
                    metadata.append("}");
                    request.setEntity((HttpEntity)new StringEntity(metadata.toString(), ContentType.create((String)"application/json", (String)StandardCharsets.UTF_8.name())));
                    if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
                        request.addHeader("X-Upload-Content-Type", status.getMime());
                    }
                    request.addHeader("Content-Type", "application/json; charset=UTF-8");
                    client = GoogleStorageWriteFeature.access$000(GoogleStorageWriteFeature.this).getHttpClient();
                    response = client.execute((HttpUriRequest)request);
                    try {
                        switch (response.getStatusLine().getStatusCode()) {
                            case 200: {
                                ** break;
lbl68:
                                // 1 sources

                                break;
                            }
                            default: {
                                throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), new GoogleStorageExceptionMappingService().parse(response)));
                            }
                        }
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    if (response.containsHeader("Location") == false) throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), new GoogleStorageExceptionMappingService().parse(response)));
                    putTarget = response.getFirstHeader("Location").getValue();
                    put = new HttpPut(putTarget);
                    put.setEntity((HttpEntity)entity);
                    putResponse = client.execute((HttpUriRequest)put);
                    try {
                        switch (putResponse.getStatusLine().getStatusCode()) {
                            case 200: 
                            case 201: {
                                var10_12 = (StorageObject)((Storage)GoogleStorageWriteFeature.access$000(GoogleStorageWriteFeature.this).getClient()).getObjectParser().parseAndClose((Reader)new InputStreamReader(putResponse.getEntity().getContent(), StandardCharsets.UTF_8), StorageObject.class);
                                return var10_12;
                            }
                        }
                        throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(putResponse.getStatusLine().getStatusCode(), new GoogleStorageExceptionMappingService().parse(putResponse)));
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)putResponse.getEntity());
                    }
                }
                catch (IOException e) {
                    throw new GoogleStorageExceptionMappingService().map("Upload {0} failed", e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public boolean timestamp() {
        return true;
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.sha256);
    }

    static /* synthetic */ GoogleStorageSession access$000(GoogleStorageWriteFeature x0) {
        return x0.session;
    }

    static /* synthetic */ PathContainerService access$100(GoogleStorageWriteFeature x0) {
        return x0.containerService;
    }
}

