/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cdn.features.DistributionLogging;
import ch.cyberduck.core.cdn.features.Index;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googlestorage.GoogleStorageBucketListService;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageLoggingFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.preferences.HostPreferences;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GoogleStorageWebsiteDistributionConfiguration
implements DistributionConfiguration,
Index {
    private final GoogleStorageSession session;
    private final PathContainerService containerService;

    public GoogleStorageWebsiteDistributionConfiguration(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public List<Distribution.Method> getMethods(Path container) {
        return Collections.singletonList(Distribution.WEBSITE);
    }

    public String getName() {
        return LocaleFactory.localizedString((String)"Website Configuration", (String)"S3");
    }

    public Distribution read(Path file, Distribution.Method method, LoginCallback prompt) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        URI origin = URI.create(String.format("%s://%s.%s", method.getScheme(), container.getName(), this.session.getHost().getProtocol().getDefaultHostname()));
        try {
            Bucket.Logging logging;
            Bucket configuration = (Bucket)((Storage)this.session.getClient()).buckets().get(container.getName()).execute();
            Bucket.Website website = configuration.getWebsite();
            Distribution distribution = new Distribution(method, this.getName(), origin, website != null);
            if (website != null) {
                distribution.setUrl(URI.create(String.format("%s://%s.%s", method.getScheme(), container.getName(), this.session.getHost().getProtocol().getDefaultHostname())));
                distribution.setStatus(LocaleFactory.localizedString((String)"Deployed", (String)"S3"));
                distribution.setIndexDocument(website.getMainPageSuffix());
            }
            if ((logging = configuration.getLogging()) != null) {
                distribution.setLogging(logging.getLogObjectPrefix() != null);
                distribution.setLoggingContainer(logging.getLogBucket());
                distribution.setContainers(new GoogleStorageBucketListService(this.session).list(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)), (ListProgressListener)new DisabledListProgressListener()).toList());
            }
            return distribution;
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Cannot read CDN configuration", e);
        }
    }

    public void write(Path file, Distribution distribution, LoginCallback prompt) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        try {
            String suffix = "index.html";
            if (StringUtils.isNotBlank((CharSequence)distribution.getIndexDocument())) {
                suffix = PathNormalizer.name((String)distribution.getIndexDocument());
            }
            ((Storage)this.session.getClient()).buckets().patch(container.getName(), new Bucket().setLogging(new Bucket.Logging().setLogObjectPrefix(distribution.isEnabled() ? new HostPreferences(this.session.getHost()).getProperty("google.logging.prefix") : null).setLogBucket(StringUtils.isNotBlank((CharSequence)distribution.getLoggingContainer()) ? distribution.getLoggingContainer() : container.getName())).setWebsite(distribution.isEnabled() ? new Bucket.Website().setMainPageSuffix(suffix) : null)).execute();
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Cannot write website configuration", e);
        }
    }

    public <T> T getFeature(Class<T> type, Distribution.Method method) {
        if (type == Index.class) {
            return (T)this;
        }
        if (type == DistributionLogging.class) {
            return (T)new GoogleStorageLoggingFeature(this.session);
        }
        return null;
    }
}

