/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.googlestorage.GoogleStorageCopyFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageObjectListService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import java.io.IOException;

public class GoogleStorageVersioningFeature
implements Versioning {
    private final PathContainerService containerService;
    private final GoogleStorageSession session;
    private final LRUCache<Path, VersioningConfiguration> cache = LRUCache.build((long)10L);

    public GoogleStorageVersioningFeature(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public VersioningConfiguration getConfiguration(Path file) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        if (container.isRoot()) {
            return VersioningConfiguration.empty();
        }
        if (this.cache.contains((Object)container)) {
            return (VersioningConfiguration)this.cache.get((Object)container);
        }
        try {
            Bucket.Versioning versioning = ((Bucket)((Storage)this.session.getClient()).buckets().get(container.getName()).execute()).getVersioning();
            VersioningConfiguration configuration = new VersioningConfiguration(versioning != null && versioning.getEnabled() != false);
            this.cache.put((Object)container, (Object)configuration);
            return configuration;
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Failure to read attributes of {0}", e, container);
        }
    }

    public void setConfiguration(Path file, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        try {
            ((Storage)this.session.getClient()).buckets().patch(container.getName(), new Bucket().setVersioning(new Bucket.Versioning().setEnabled(Boolean.valueOf(configuration.isEnabled())))).execute();
            this.cache.remove((Object)container);
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Failure to write attributes of {0}", e, container);
        }
    }

    public void revert(Path file) throws BackgroundException {
        new GoogleStorageCopyFeature(this.session).copy(file, file, new TransferStatus(), (ConnectionCallback)new DisabledConnectionCallback(), (StreamListener)new DisabledStreamListener());
    }

    public boolean isRevertable(Path file) {
        return file.attributes().isDuplicate();
    }

    public AttributedList<Path> list(Path file, ListProgressListener listener) throws BackgroundException {
        return new GoogleStorageObjectListService(this.session).list(file, listener).filter((Filter)new NullFilter<Path>(){

            public boolean accept(Path file) {
                return file.attributes().isDuplicate();
            }
        });
    }
}

