/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionUrlProvider;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;

public class GoogleStorageUrlProvider
implements UrlProvider {
    private final PathContainerService containerService;
    private final GoogleStorageSession session;

    public GoogleStorageUrlProvider(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DefaultUrlProvider(this.session.getHost()).toUrl(file);
        if (file.isFile()) {
            list.add(new DescriptiveUrl(URI.create(String.format("https://storage.cloud.google.com%s", URIEncoder.encode((String)file.getAbsolute()))), DescriptiveUrl.Type.authenticated, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Authenticated"))));
            Distribution distribution = new Distribution(Distribution.DOWNLOAD, URI.create(String.format("%s://%s.%s", Distribution.DOWNLOAD.getScheme(), this.containerService.getContainer(file).getName(), this.session.getHost().getProtocol().getDefaultHostname())), false);
            distribution.setUrl(URI.create(String.format("%s://%s.%s", Distribution.DOWNLOAD.getScheme(), this.containerService.getContainer(file).getName(), this.session.getHost().getProtocol().getDefaultHostname())));
            list.addAll((Collection)new DistributionUrlProvider(distribution).toUrl(file));
        }
        list.add(new DescriptiveUrl(URI.create(String.format("gs://%s%s", this.containerService.getContainer(file).getName(), file.isRoot() ? Character.valueOf('/') : (this.containerService.isContainer(file) ? Character.valueOf('/') : String.format("/%s", URIEncoder.encode((String)this.containerService.getKey(file)))))), DescriptiveUrl.Type.provider, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), this.session.getHost().getProtocol().getName())));
        return list;
    }
}

