/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.client.util.DateTime;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleStorageTimestampFeature
extends DefaultTimestampFeature {
    private static final Logger log = LogManager.getLogger(GoogleStorageTimestampFeature.class);
    private final GoogleStorageSession session;
    private final PathContainerService containerService;

    public GoogleStorageTimestampFeature(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public void setTimestamp(Path file, TransferStatus status) throws BackgroundException {
        if (file.isFile() || file.isPlaceholder()) {
            try {
                ((Storage)this.session.getClient()).objects().patch(this.containerService.getContainer(file).getName(), this.containerService.getKey(file), new StorageObject().setCustomTime(new DateTime(status.getTimestamp().longValue()))).execute();
            }
            catch (IOException e) {
                BackgroundException failure = new GoogleStorageExceptionMappingService().map("Failure to write attributes of {0}", e, file);
                if (file.isPlaceholder() && failure instanceof NotfoundException) {
                    return;
                }
                throw failure;
            }
        }
    }
}

