/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.RewriteResponse;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

public class GoogleStorageStorageClassFeature
implements Redundancy {
    private final GoogleStorageSession session;
    private final PathContainerService containerService;

    public GoogleStorageStorageClassFeature(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public String getDefault() {
        return new HostPreferences(this.session.getHost()).getProperty("googlestorage.storage.class");
    }

    public Set<String> getClasses() {
        return new LinkedHashSet<String>(PreferencesFactory.get().getList("googlestorage.storage.class.options"));
    }

    public String getClass(Path file) throws BackgroundException {
        return new GoogleStorageAttributesFinderFeature(this.session).find(file).getStorageClass();
    }

    public void setClass(Path file, String redundancy) throws BackgroundException {
        try {
            if (this.containerService.isContainer(file)) {
                ((Storage)this.session.getClient()).buckets().patch(this.containerService.getContainer(file).getName(), new Bucket().setStorageClass(redundancy)).execute();
            } else {
                RewriteResponse response = (RewriteResponse)((Storage)this.session.getClient()).objects().rewrite(this.containerService.getContainer(file).getName(), this.containerService.getKey(file), this.containerService.getContainer(file).getName(), this.containerService.getKey(file), new StorageObject().setStorageClass(redundancy)).execute();
                file.attributes().setVersionId(String.valueOf(response.getResource().getGeneration()));
            }
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

