/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.client.http.HttpHeaders;
import com.google.api.services.storage.Storage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleStorageReadFeature
implements Read {
    private static final Logger log = LogManager.getLogger(GoogleStorageReadFeature.class);
    private final PathContainerService containerService;
    private final GoogleStorageSession session;

    public GoogleStorageReadFeature(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            VersioningConfiguration versioning;
            if (0L == status.getLength()) {
                return new NullInputStream(0L);
            }
            Storage.Objects.Get request = ((Storage)this.session.getClient()).objects().get(this.containerService.getContainer(file).getName(), this.containerService.getKey(file));
            VersioningConfiguration versioningConfiguration = versioning = null != this.session.getFeature(Versioning.class) ? ((Versioning)this.session.getFeature(Versioning.class)).getConfiguration(this.containerService.getContainer(file)) : VersioningConfiguration.empty();
            if (versioning.isEnabled() && StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
                request.setGeneration(Long.valueOf(Long.parseLong(file.attributes().getVersionId())));
            }
            if (status.isAppend()) {
                HttpRange range = HttpRange.withStatus((TransferStatus)status);
                String header = -1L == range.getEnd() ? String.format("bytes=%d-", range.getStart()) : String.format("bytes=%d-%d", range.getStart(), range.getEnd());
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add range header %s for file %s", header, file));
                }
                HttpHeaders headers = request.getRequestHeaders();
                headers.setRange(header);
                headers.setAcceptEncoding("identity");
            }
            return request.executeMediaAsInputStream();
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Download {0} failed", e, file);
        }
    }
}

