/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.googlestorage.GoogleStorageAccessControlListFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.googlestorage.GoogleStorageUrlProvider;
import org.jets3t.service.acl.Permission;

public class GoogleStoragePublicUrlProvider
implements PromptUrlProvider<Void, Void> {
    private final GoogleStorageSession session;

    public GoogleStoragePublicUrlProvider(GoogleStorageSession session) {
        this.session = session;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case download: {
                return file.isFile();
            }
        }
        return false;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        GoogleStorageAccessControlListFeature acl = new GoogleStorageAccessControlListFeature(this.session);
        Acl permission = acl.getPermission(file);
        Acl.GroupUser everyone = new Acl.GroupUser("AllUsers");
        Acl.Role read = new Acl.Role(Permission.PERMISSION_READ.toString());
        if (!permission.asList().contains(new Acl.UserAndRole((Acl.User)everyone, read))) {
            permission.addAll((Acl.User)everyone, new Acl.Role[]{read});
            acl.setPermission(file, permission);
        }
        return new GoogleStorageUrlProvider(this.session).toUrl(file).find(DescriptiveUrl.Type.provider);
    }

    public DescriptiveUrl toUploadUrl(Path file, Void options, PasswordCallback callback) {
        return DescriptiveUrl.EMPTY;
    }
}

