/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.DirectoryDelimiterPathContainerService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.googlestorage.GoogleStorageLocationFeature;
import ch.cyberduck.core.text.DefaultLexicographicOrderComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public final class GoogleStorageProtocol
extends AbstractProtocol {
    public String getName() {
        return "Google Storage";
    }

    public String getDescription() {
        return LocaleFactory.localizedString((String)"Google Cloud Storage", (String)"S3");
    }

    public String getIdentifier() {
        return "gs";
    }

    public Protocol.Type getType() {
        return Protocol.Type.googlestorage;
    }

    public String getPrefix() {
        return String.format("%s.%s", GoogleStorageProtocol.class.getPackage().getName(), "GoogleStorage");
    }

    public String disk() {
        return String.format("%s.tiff", "googlestorage");
    }

    public boolean isHostnameConfigurable() {
        return false;
    }

    public boolean isPasswordConfigurable() {
        return false;
    }

    public Set<Location.Name> getRegions() {
        return new HashSet<Location.Name>(Arrays.asList(new GoogleStorageLocationFeature.GoogleStorageRegion("us"), new GoogleStorageLocationFeature.GoogleStorageRegion("eu"), new GoogleStorageLocationFeature.GoogleStorageRegion("asia")));
    }

    public Scheme getScheme() {
        return Scheme.https;
    }

    public boolean isPortConfigurable() {
        return false;
    }

    public String getUsernamePlaceholder() {
        return LocaleFactory.localizedString((String)"Project ID or Number", (String)"Credentials");
    }

    public String getPasswordPlaceholder() {
        return LocaleFactory.localizedString((String)"Authorization code", (String)"Credentials");
    }

    public String favicon() {
        return this.icon();
    }

    public Protocol.DirectoryTimestamp getDirectoryTimestamp() {
        return Protocol.DirectoryTimestamp.explicit;
    }

    public Comparator<String> getListComparator() {
        return new DefaultLexicographicOrderComparator();
    }

    public <T> T getFeature(Class<T> type) {
        if (type == PathContainerService.class) {
            return (T)new DirectoryDelimiterPathContainerService();
        }
        return (T)super.getFeature(type);
    }
}

