/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleStorageObjectListService
implements ListService {
    private static final Logger log = LogManager.getLogger(GoogleStorageObjectListService.class);
    private final GoogleStorageSession session;
    private final GoogleStorageAttributesFinderFeature attributes;
    private final PathContainerService containerService;
    private final Integer concurrency;

    public GoogleStorageObjectListService(GoogleStorageSession session) {
        this(session, new HostPreferences(session.getHost()).getInteger("googlestorage.listing.concurrency"));
    }

    public GoogleStorageObjectListService(GoogleStorageSession session, Integer concurrency) {
        this.session = session;
        this.attributes = new GoogleStorageAttributesFinderFeature(session);
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.concurrency = concurrency;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return this.list(directory, listener, String.valueOf('/'));
    }

    protected AttributedList<Path> list(Path directory, ListProgressListener listener, String delimiter) throws BackgroundException {
        return this.list(directory, listener, delimiter, new HostPreferences(this.session.getHost()).getInteger("googlestorage.listing.chunksize"));
    }

    protected AttributedList<Path> list(Path directory, ListProgressListener listener, String delimiter, int chunksize) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"list", (int)this.concurrency);
        try {
            Path bucket = this.containerService.getContainer(directory);
            VersioningConfiguration versioning = null != this.session.getFeature(Versioning.class) ? ((Versioning)this.session.getFeature(Versioning.class)).getConfiguration(this.containerService.getContainer(directory)) : VersioningConfiguration.empty();
            AttributedList objects = new AttributedList();
            ArrayList<Future> folders = new ArrayList<Future>();
            long revision = 0L;
            String lastKey = null;
            String page = null;
            boolean hasDirectoryPlaceholder = this.containerService.isContainer(directory);
            do {
                String key;
                Objects response;
                if ((response = (Objects)((Storage)this.session.getClient()).objects().list(bucket.getName()).setPageToken(page).setVersions(Boolean.valueOf(versioning.isEnabled())).setMaxResults(Long.valueOf(chunksize)).setDelimiter(delimiter).setPrefix(this.createPrefix(directory)).execute()).getItems() != null) {
                    for (StorageObject object : response.getItems()) {
                        key = PathNormalizer.normalize((String)object.getName());
                        if (String.valueOf('/').equals(key)) {
                            log.warn(String.format("Skipping prefix %s", key));
                            continue;
                        }
                        if (new SimplePathPredicate(new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory))).test(directory)) {
                            hasDirectoryPlaceholder = true;
                            continue;
                        }
                        if (!StringUtils.equals(lastKey, (CharSequence)key)) {
                            revision = 0L;
                        }
                        EnumSet<AbstractPath.Type> types = object.getName().endsWith(String.valueOf('/')) ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file);
                        PathAttributes attr = this.attributes.toAttributes(object);
                        attr.setRevision(Long.valueOf(++revision));
                        attr.setRegion(bucket.attributes().getRegion());
                        Path file = null == delimiter ? new Path(String.format("%s%s", bucket.getAbsolute(), key), types, attr) : new Path(directory.isDirectory() ? directory : directory.getParent(), PathNormalizer.name((String)key), types, attr);
                        objects.add((Referenceable)file);
                        lastKey = key;
                    }
                }
                if (response.getPrefixes() != null) {
                    for (String prefix : response.getPrefixes()) {
                        if (String.valueOf('/').equals(prefix)) {
                            log.warn(String.format("Skipping prefix %s", prefix));
                            continue;
                        }
                        key = PathNormalizer.normalize((String)prefix);
                        if (new SimplePathPredicate(new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory))).test(directory)) continue;
                        PathAttributes attributes = new PathAttributes();
                        attributes.setRegion(bucket.attributes().getRegion());
                        Path file = null == delimiter ? new Path(String.format("%s%s", bucket.getAbsolute(), key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes) : new Path(directory, PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes);
                        if (versioning.isEnabled()) {
                            folders.add(this.submit(pool, bucket, directory, URIEncoder.decode((String)prefix)));
                            continue;
                        }
                        folders.add(ConcurrentUtils.constantFuture((Object)file));
                    }
                }
                page = response.getNextPageToken();
                listener.chunk(directory, objects);
            } while (page != null);
            for (Future f : folders) {
                try {
                    objects.add((Referenceable)((Path)Uninterruptibles.getUninterruptibly((Future)f)));
                }
                catch (ExecutionException e) {
                    log.warn(String.format("Listing versioned objects failed with execution failure %s", e.getMessage()));
                    Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                    throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                }
            }
            listener.chunk(directory, objects);
            if (!hasDirectoryPlaceholder && objects.isEmpty()) {
                throw new NotfoundException(directory.getAbsolute());
            }
            return objects;
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    private Future<Path> submit(ThreadPool pool, final Path bucket, final Path directory, final String common) {
        return pool.execute((Callable)new BackgroundExceptionCallable<Path>(){

            public Path call() throws BackgroundException {
                PathAttributes attr = new PathAttributes();
                attr.setRegion(bucket.attributes().getRegion());
                Path prefix = new Path(directory, PathNormalizer.name((String)common), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attr);
                try {
                    Objects versions = (Objects)((Storage)GoogleStorageObjectListService.this.session.getClient()).objects().list(bucket.getName()).setVersions(Boolean.valueOf(true)).setMaxResults(Long.valueOf(1L)).setPrefix(common).execute();
                    if (null != versions.getItems() && versions.getItems().size() == 1) {
                        Objects unversioned;
                        StorageObject version = (StorageObject)versions.getItems().get(0);
                        if (URIEncoder.decode((String)version.getName()).equals(common)) {
                            attr.setVersionId(String.valueOf(version.getGeneration()));
                        }
                        if (null == (unversioned = (Objects)((Storage)GoogleStorageObjectListService.this.session.getClient()).objects().list(bucket.getName()).setVersions(Boolean.valueOf(false)).setMaxResults(Long.valueOf(1L)).setPrefix(common).execute()).getItems() || unversioned.getItems().size() == 0) {
                            attr.setDuplicate(true);
                        }
                    }
                    return prefix;
                }
                catch (IOException e) {
                    throw new GoogleStorageExceptionMappingService().map("Listing directory {0} failed", e, prefix);
                }
            }
        });
    }

    protected String createPrefix(Path directory) {
        String prefix = "";
        if (!this.containerService.isContainer(directory)) {
            prefix = this.containerService.getKey(directory);
            if (StringUtils.isBlank((CharSequence)prefix)) {
                return "";
            }
            if (directory.isDirectory() && !prefix.endsWith(String.valueOf('/'))) {
                prefix = prefix + '/';
            }
        }
        return prefix;
    }
}

