/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.googlestorage.GoogleStorageCopyFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageDeleteFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;

public class GoogleStorageMoveFeature
implements Move {
    private final PathContainerService containerService;
    private final GoogleStorageSession session;

    public GoogleStorageMoveFeature(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public Path move(Path source, Path target, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        Path copy = new GoogleStorageCopyFeature(this.session).copy(source, target, status, connectionCallback, (StreamListener)new DisabledStreamListener());
        new GoogleStorageDeleteFeature(this.session).delete(Collections.singletonMap(source, status), (PasswordCallback)connectionCallback, callback);
        return copy;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source);
    }
}

