/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleStorageMetadataFeature
implements Headers {
    private static final Logger log = LogManager.getLogger(GoogleStorageMetadataFeature.class);
    private final GoogleStorageSession session;
    private final PathContainerService containerService;

    public GoogleStorageMetadataFeature(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public Map<String, String> getDefault(Local local) {
        return new HostPreferences(this.session.getHost()).getMap("googlestorage.metadata.default");
    }

    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        if (file.isFile() || file.isPlaceholder()) {
            try {
                return new GoogleStorageAttributesFinderFeature(this.session).find(file).getMetadata();
            }
            catch (NotfoundException e) {
                if (file.isPlaceholder()) {
                    return Collections.emptyMap();
                }
                throw e;
            }
        }
        return Collections.emptyMap();
    }

    public void setMetadata(Path file, TransferStatus status) throws BackgroundException {
        if (file.isFile() || file.isPlaceholder()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Write metadata %s for file %s", status, file));
            }
            try {
                ((Storage)this.session.getClient()).objects().patch(this.containerService.getContainer(file).getName(), this.containerService.getKey(file), new StorageObject().setMetadata(status.getMetadata())).execute();
            }
            catch (IOException e) {
                BackgroundException failure = new GoogleStorageExceptionMappingService().map("Failure to write attributes of {0}", e, file);
                if (file.isPlaceholder() && failure instanceof NotfoundException) {
                    return;
                }
                throw failure;
            }
        }
    }
}

