/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.preferences.HostPreferences;
import java.util.Set;

public class GoogleStorageLocationFeature
implements Location {
    private final GoogleStorageSession session;
    private final PathContainerService containerService;

    public GoogleStorageLocationFeature(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public Location.Name getDefault() {
        return new GoogleStorageRegion(new HostPreferences(this.session.getHost()).getProperty("googlestorage.location"));
    }

    public Set<Location.Name> getLocations() {
        return this.session.getHost().getProtocol().getRegions();
    }

    public Location.Name getLocation(Path file) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        if (container.isRoot()) {
            return unknown;
        }
        return new GoogleStorageRegion(new GoogleStorageAttributesFinderFeature(this.session).find(container).getRegion());
    }

    public static final class GoogleStorageRegion
    extends Location.Name {
        public GoogleStorageRegion(String identifier) {
            super(identifier);
        }

        public String toString() {
            String identifier = this.getIdentifier();
            if (null == identifier) {
                return LocaleFactory.localizedString((String)"Unknown");
            }
            return LocaleFactory.localizedString((String)identifier, (String)"S3");
        }
    }
}

