/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import com.google.api.client.json.gson.GsonFactory;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleStorageExceptionMappingService
extends DefaultIOExceptionMappingService {
    private static final Logger log = LogManager.getLogger(GoogleStorageExceptionMappingService.class);

    public BackgroundException map(IOException failure) {
        GoogleJsonResponseException error;
        GoogleJsonError details;
        StringBuilder buffer = new StringBuilder();
        if (failure instanceof GoogleJsonResponseException && (details = (error = (GoogleJsonResponseException)failure).getDetails()) != null) {
            this.append(buffer, error.getDetails().getMessage());
            Optional optionalInfo = details.getErrors().stream().findFirst();
            if (optionalInfo.isPresent()) {
                GoogleJsonError.ErrorInfo info = (GoogleJsonError.ErrorInfo)optionalInfo.get();
                this.append(buffer, "domain: " + info.getDomain());
                this.append(buffer, "reason: " + info.getReason());
                if ("usageLimits".equals(info.getDomain()) && details.getCode() == 403) {
                    return new RetriableAccessDeniedException(buffer.toString(), Duration.ofSeconds(PreferencesFactory.get().getInteger("connection.retry.delay")), (Throwable)failure);
                }
            }
        }
        if (failure instanceof com.google.api.client.http.HttpResponseException) {
            com.google.api.client.http.HttpResponseException response = (com.google.api.client.http.HttpResponseException)failure;
            this.append(buffer, response.getStatusMessage());
            return new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusCode(), buffer.toString()));
        }
        return super.map(failure);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String parse(HttpResponse response) {
        if (response.getEntity() == null) return response.getStatusLine().getReasonPhrase();
        try (JsonParser parser = new GsonFactory().createJsonParser(response.getEntity().getContent());){
            JsonToken currentToken = parser.getCurrentToken();
            if (currentToken == null) {
                currentToken = parser.nextToken();
            }
            if (currentToken != null) {
                parser.skipToKey("error");
                if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                    String string = parser.getText();
                    return string;
                }
                if (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                    StringBuilder details = new StringBuilder();
                    GoogleJsonError error = (GoogleJsonError)parser.parseAndClose(GoogleJsonError.class);
                    Object object = error.getErrors().iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            object = details.toString();
                            return object;
                        }
                        GoogleJsonError.ErrorInfo info = (GoogleJsonError.ErrorInfo)object.next();
                        details.append(info.getMessage());
                    }
                }
            }
            parser.close();
            return response.getStatusLine().getReasonPhrase();
        }
        catch (IOException exception) {
            log.warn(String.format("Ignore failure %s parsing error reply from %s", exception, response));
        }
        return response.getStatusLine().getReasonPhrase();
    }
}

