/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.googlestorage.GoogleStorageTouchFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.util.EnumSet;

public class GoogleStorageDirectoryFeature
implements Directory<StorageObject> {
    private static final String MIMETYPE = "application/x-directory";
    private final PathContainerService containerService;
    private final GoogleStorageSession session;
    private Write<StorageObject> writer;

    public GoogleStorageDirectoryFeature(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
        this.writer = new GoogleStorageWriteFeature(session);
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            if (this.containerService.isContainer(folder)) {
                Bucket bucket = (Bucket)((Storage)this.session.getClient()).buckets().insert(this.session.getHost().getCredentials().getUsername(), new Bucket().setLocation(status.getRegion()).setStorageClass(status.getStorageClass()).setName(this.containerService.getContainer(folder).getName())).execute();
                EnumSet<AbstractPath.Type> type = EnumSet.copyOf(folder.getType());
                type.add(AbstractPath.Type.volume);
                return folder.withType(type).withAttributes(new GoogleStorageAttributesFinderFeature(this.session).toAttributes(bucket));
            }
            EnumSet<AbstractPath.Type> type = EnumSet.copyOf(folder.getType());
            type.add(AbstractPath.Type.placeholder);
            return new GoogleStorageTouchFeature(this.session).withWriter(this.writer).touch(folder.withType(type), status.withMime(MIMETYPE));
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
    }

    public Directory<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return this;
    }
}

