/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.storage.Storage;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleStorageDeleteFeature
implements Delete {
    private static final Logger log = LogManager.getLogger(GoogleStorageDeleteFeature.class);
    private final PathContainerService containerService;
    private final GoogleStorageSession session;

    public GoogleStorageDeleteFeature(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files.keySet()) {
            try {
                VersioningConfiguration versioning;
                callback.delete(file);
                if (this.containerService.isContainer(file)) {
                    ((Storage)this.session.getClient()).buckets().delete(file.getName()).execute();
                }
                if (!file.isFile() && !file.isPlaceholder()) continue;
                Storage.Objects.Delete request = ((Storage)this.session.getClient()).objects().delete(this.containerService.getContainer(file).getName(), this.containerService.getKey(file));
                VersioningConfiguration versioningConfiguration = versioning = null != this.session.getFeature(Versioning.class) ? ((Versioning)this.session.getFeature(Versioning.class)).getConfiguration(this.containerService.getContainer(file)) : VersioningConfiguration.empty();
                if (versioning.isEnabled() && StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
                    request.setGeneration(Long.valueOf(Long.parseLong(file.attributes().getVersionId())));
                }
                request.execute();
            }
            catch (IOException e) {
                BackgroundException failure = new GoogleStorageExceptionMappingService().map("Cannot delete {0}", e, file);
                if (file.isPlaceholder() && failure instanceof NotfoundException) continue;
                throw failure;
            }
        }
    }

    public boolean isSupported(Path file) {
        return true;
    }
}

