/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageMoveFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.RewriteResponse;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleStorageCopyFeature
implements Copy {
    private static final Logger log = LogManager.getLogger(GoogleStorageMoveFeature.class);
    private final PathContainerService containerService;
    private final GoogleStorageSession session;

    public GoogleStorageCopyFeature(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        try {
            RewriteResponse response;
            Storage.Objects.Get request = ((Storage)this.session.getClient()).objects().get(this.containerService.getContainer(source).getName(), this.containerService.getKey(source));
            if (StringUtils.isNotBlank((CharSequence)source.attributes().getVersionId())) {
                request.setGeneration(Long.valueOf(Long.parseLong(source.attributes().getVersionId())));
            }
            StorageObject storageObject = (StorageObject)request.execute();
            Storage.Objects.Rewrite rewrite = ((Storage)this.session.getClient()).objects().rewrite(this.containerService.getContainer(source).getName(), this.containerService.getKey(source), this.containerService.getContainer(target).getName(), this.containerService.getKey(target), storageObject);
            do {
                response = (RewriteResponse)rewrite.execute();
                rewrite.setRewriteToken(response.getRewriteToken());
            } while (!response.getDone().booleanValue());
            listener.sent(status.getLength());
            return target.withAttributes(new GoogleStorageAttributesFinderFeature(this.session).toAttributes(response.getResource()));
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Cannot copy {0}", e, source);
        }
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source) && !this.containerService.isContainer(target);
    }
}

