/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.io.Checksum;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleStorageAttributesFinderFeature
implements AttributesFinder,
AttributesAdapter<StorageObject> {
    private static final Logger log = LogManager.getLogger(GoogleStorageAttributesFinderFeature.class);
    private final PathContainerService containerService;
    private final GoogleStorageSession session;

    public GoogleStorageAttributesFinderFeature(GoogleStorageSession session) {
        this.session = session;
        this.containerService = (PathContainerService)session.getFeature(PathContainerService.class);
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        try {
            VersioningConfiguration versioning;
            if (this.containerService.isContainer(file)) {
                return this.toAttributes((Bucket)((Storage)this.session.getClient()).buckets().get(this.containerService.getContainer(file).getName()).execute());
            }
            Storage.Objects.Get request = ((Storage)this.session.getClient()).objects().get(this.containerService.getContainer(file).getName(), this.containerService.getKey(file));
            VersioningConfiguration versioningConfiguration = versioning = null != this.session.getFeature(Versioning.class) ? ((Versioning)this.session.getFeature(Versioning.class)).getConfiguration(this.containerService.getContainer(file)) : VersioningConfiguration.empty();
            if (versioning.isEnabled() && StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
                request.setGeneration(Long.valueOf(Long.parseLong(file.attributes().getVersionId())));
            }
            PathAttributes attributes = this.toAttributes((StorageObject)request.execute());
            if (versioning.isEnabled()) {
                try {
                    String latest = this.toAttributes((StorageObject)((Storage)this.session.getClient()).objects().get(this.containerService.getContainer(file).getName(), this.containerService.getKey(file)).execute()).getVersionId();
                    if (null != latest) {
                        attributes.setDuplicate(!latest.equals(attributes.getVersionId()));
                    }
                }
                catch (IOException e) {
                    BackgroundException failure = new GoogleStorageExceptionMappingService().map("Failure to read attributes of {0}", e, file);
                    if (failure instanceof NotfoundException) {
                        attributes.setDuplicate(true);
                    }
                    throw failure;
                }
            }
            return attributes;
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    protected PathAttributes toAttributes(Bucket bucket) {
        PathAttributes attributes = new PathAttributes();
        attributes.setRegion(bucket.getLocation());
        attributes.setStorageClass(bucket.getStorageClass());
        attributes.setCreationDate(bucket.getTimeCreated().getValue());
        attributes.setETag(bucket.getEtag());
        if (bucket.getEncryption() != null) {
            attributes.setEncryption(new Encryption.Algorithm("AES256", bucket.getEncryption().getDefaultKmsKeyName()));
        }
        attributes.setRegion(bucket.getLocation());
        return attributes;
    }

    public PathAttributes toAttributes(StorageObject object) {
        PathAttributes attributes = new PathAttributes();
        if (object.getSize() != null) {
            attributes.setSize(object.getSize().longValue());
        }
        if (object.getTimeCreated() != null) {
            attributes.setCreationDate(object.getTimeCreated().getValue());
        }
        if (object.getUpdated() != null) {
            attributes.setModificationDate(object.getUpdated().getValue());
        }
        if (object.getCustomTime() != null) {
            attributes.setModificationDate(object.getCustomTime().getValue());
        }
        attributes.setStorageClass(object.getStorageClass());
        if (StringUtils.isNotBlank((CharSequence)object.getEtag())) {
            attributes.setETag(object.getEtag());
        }
        attributes.setVersionId(String.valueOf(object.getGeneration()));
        attributes.setDuplicate(object.getTimeDeleted() != null);
        if (object.getKmsKeyName() != null) {
            attributes.setEncryption(new Encryption.Algorithm("AES256", object.getKmsKeyName()){

                public String getDescription() {
                    return String.format("SSE-KMS (%s)", this.key);
                }
            });
        }
        attributes.setChecksum(Checksum.parse((String)object.getMd5Hash()));
        if (object.getMetadata() != null) {
            attributes.setMetadata(object.getMetadata());
        }
        return attributes;
    }
}

