/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.status;

import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import com.dd.plist.NSDictionary;

public class SyncQueueStatusService
implements FileStatusService {
    private final SyncQueue queue;
    private final LocalCache<?> cache;
    private final MetadataService<NSDictionary> metadata;

    public SyncQueueStatusService(SyncQueue queue, LocalCache<?> cache, MetadataService<NSDictionary> metadata) {
        this.queue = queue;
        this.cache = cache;
        this.metadata = metadata;
    }

    public FileStatusService.Status getStatus(Path file) {
        switch (this.queue.getStatus(file)) {
            case busy: {
                if (this.metadata.read(this.cache.toLocal(file), MetadataStorage.Key.skip) != null) {
                    return new FileStatusService.Status(FileStatusService.SyncState.unknown);
                }
                return new FileStatusService.Status(FileStatusService.SyncState.inprogress);
            }
        }
        return new FileStatusService.Status(FileStatusService.SyncState.unknown);
    }
}

