/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.status;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.diagnostics.Reachability;
import ch.cyberduck.core.diagnostics.ReachabilityFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.threading.NamedThreadFactory;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import ch.cyberduck.core.transfer.TransferProgress;
import ch.iterate.mountainduck.fs.NotificationServiceAlertCallback;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReachabilityStatusService
implements FileStatusService,
Reachability.Callback,
SyncQueue.Listener,
DirectoryIndexer.Listener {
    private static final Logger log = LogManager.getLogger((String)ReachabilityStatusService.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final Host bookmark;
    private final Reachability reachability = ReachabilityFactory.get();
    private final Reachability.Monitor monitor;
    private final Lock lock = new ReentrantLock();
    private final AtomicReference<Boolean> reachable;
    private final SyncQueue queue;
    private final DirectoryIndexer indexer;
    private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("reachability"));
    private final ScheduledThreadPool scheduler = new ScheduledThreadPool();
    private final AlertCallback alert = new NotificationServiceAlertCallback();

    public ReachabilityStatusService(SyncQueue queue, DirectoryIndexer indexer, Host bookmark) {
        this.queue = queue;
        this.indexer = indexer;
        this.bookmark = bookmark;
        this.reachable = new AtomicReference();
        this.monitor = this.reachability.monitor(bookmark, (Reachability.Callback)this).start();
    }

    public FileStatusService.Status getStatus(Path file) {
        Boolean status = this.reachable.get();
        if (null == status) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Test reachability for %s", this.bookmark));
            }
            this.reachable.set(this.reachability.isReachable(this.bookmark));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Reachability set to %s for %s", status, this.bookmark));
        }
        return Boolean.TRUE.equals(status) ? new FileStatusService.Status(FileStatusService.SyncState.unknown) : new FileStatusService.Status(FileStatusService.SyncState.local);
    }

    public void change() {
        this.executor.submit(new Callable<SyncQueue.Status>(){

            @Override
            public SyncQueue.Status call() throws ExecutionException, InterruptedException {
                block20: {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Wait for lock to test reachability for %s", ReachabilityStatusService.this.bookmark));
                    }
                    ReachabilityStatusService.this.lock.lock();
                    try {
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Test for reachability of %s", ReachabilityStatusService.this.bookmark));
                        }
                        ReachabilityStatusService.this.reachable.set(ReachabilityStatusService.this.reachability.isReachable(ReachabilityStatusService.this.bookmark));
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Set reachability to %s for %s", ReachabilityStatusService.this.reachable.get(), ReachabilityStatusService.this.bookmark));
                        }
                        if (((Boolean)ReachabilityStatusService.this.reachable.get()).booleanValue()) {
                            switch (ReachabilityStatusService.this.queue.getStatus()) {
                                case stopped: {
                                    ReachabilityStatusService.this.queue.resume().get();
                                    if (!ReachabilityStatusService.this.preferences.getBoolean("fs.sync.queue.reachability.notification.resume.enable")) break;
                                    ReachabilityStatusService.this.alert.alert(ReachabilityStatusService.this.bookmark, (BackgroundException)new ConnectionCanceledException(LocaleFactory.localizedString((String)"Resume Sync", (String)"Disk"), BookmarkNameProvider.toString((Host)ReachabilityStatusService.this.bookmark)));
                                }
                            }
                            switch (ReachabilityStatusService.this.indexer.getStatus()) {
                                case stopped: {
                                    ReachabilityStatusService.this.indexer.resume();
                                }
                            }
                            break block20;
                        }
                        switch (ReachabilityStatusService.this.queue.getStatus()) {
                            case idle: 
                            case busy: {
                                ReachabilityStatusService.this.queue.pause(SyncQueue.Status.stopped, (BackgroundException)new ConnectionCanceledException(LocaleFactory.localizedString((String)"Connection failed", (String)"Error"))).get();
                            }
                        }
                        switch (ReachabilityStatusService.this.indexer.getStatus()) {
                            case idle: 
                            case busy: {
                                ReachabilityStatusService.this.indexer.pause(DirectoryIndexer.Status.stopped, (BackgroundException)new ConnectionCanceledException(LocaleFactory.localizedString((String)"Connection failed", (String)"Error")));
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Release lock for %s", ReachabilityStatusService.this.bookmark));
                        }
                        ReachabilityStatusService.this.lock.unlock();
                        throw throwable;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Release lock for %s", ReachabilityStatusService.this.bookmark));
                }
                ReachabilityStatusService.this.lock.unlock();
                return ReachabilityStatusService.this.queue.getStatus();
            }
        });
    }

    public void shutdown() {
        this.monitor.stop();
        this.scheduler.shutdown();
    }

    public void fileStatusChanged(Set<Path> file, Operation operation, FileStatusService.Status status) {
    }

    public void queueStatusChanged(SyncQueue.Status status, BackgroundException failure) {
        if (SyncQueue.Status.stopped == status) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Status change to %s with failure %s", new Object[]{status, failure}));
            }
            if (failure != null && this.preferences.getBoolean("fs.sync.queue.reachability.notification.pause.enable")) {
                this.alert.alert(this.bookmark, (BackgroundException)new ConnectionCanceledException(LocaleFactory.localizedString((String)"Sync Paused", (String)"Disk"), failure.getDetail(false), (Throwable)failure));
            }
            switch (new DefaultFailureDiagnostics().determine(failure)) {
                case cancel: {
                    log.warn("Skip scheduling auto resume for sync queue");
                    break;
                }
                default: {
                    if (this.preferences.getBoolean("fs.sync.queue.reachability.schedule.enable")) {
                        this.schedule(() -> {
                            if (this.preferences.getBoolean("fs.sync.queue.reachability.notification.enable")) {
                                this.alert.alert(this.bookmark, (BackgroundException)new ConnectionCanceledException(LocaleFactory.localizedString((String)"Resume Sync", (String)"Disk"), BookmarkNameProvider.toString((Host)this.bookmark)));
                            }
                            this.queue.resume();
                        });
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug(String.format("Ignore status change to %s with failure %s", new Object[]{status, failure}));
        }
    }

    public void transferStatusChanged(TransferProgress progress) {
    }

    public void indexerStatusChanged(DirectoryIndexer.Status status, BackgroundException failure) {
        if (DirectoryIndexer.Status.stopped == status) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Status change to %s", status));
            }
            switch (new DefaultFailureDiagnostics().determine(failure)) {
                case cancel: {
                    log.warn("Skip scheduling auto resume for indexer");
                    break;
                }
                default: {
                    this.schedule(() -> ((DirectoryIndexer)this.indexer).resume());
                }
            }
        }
    }

    private void schedule(Resume resume) {
        long delay = this.preferences.getLong("fs.sync.queue.reachability.schedule.delay.seconds");
        if (log.isInfoEnabled()) {
            log.info(String.format("Schedule for reachability check in %d seconds", delay));
        }
        try {
            this.scheduler.schedule((Runnable)new ScheduledRunnable(resume, delay), Long.valueOf(this.preferences.getLong("fs.sync.queue.reachability.schedule.delay.seconds")), TimeUnit.SECONDS);
        }
        catch (RejectedExecutionException e) {
            log.warn(String.format("Failure %s scheduling reachability timer", e));
        }
    }

    static interface Resume {
        public void resume();
    }

    private final class ScheduledRunnable
    implements Runnable {
        private final Resume resume;
        private final long delay;

        public ScheduledRunnable(Resume resume, long delay) {
            this.resume = resume;
            this.delay = delay;
        }

        @Override
        public void run() {
            if (ReachabilityStatusService.this.reachability.isReachable(ReachabilityStatusService.this.bookmark)) {
                ReachabilityStatusService.this.reachable.set(true);
                this.resume.resume();
            } else {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Reschedule for reachability check in %d seconds", this.delay));
                }
                ReachabilityStatusService.this.scheduler.schedule((Runnable)this, Long.valueOf(this.delay), TimeUnit.SECONDS);
            }
        }
    }
}

