/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.status;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;

public class PlaceholderStatusService
implements FileStatusService {
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;

    public PlaceholderStatusService(LocalCache<?> cache, MetadataService<?> metadata) {
        this.cache = cache;
        this.metadata = metadata;
    }

    public FileStatusService.Status getStatus(Path file) {
        FileStatusService.Status status = this.getStatus(this.cache.toLocal(file));
        switch (status.getState()) {
            case local: {
                if (!FilesystemFilenameBlacklist.localonly.contains(file)) break;
                return new FileStatusService.Status(FileStatusService.SyncState.ignored);
            }
        }
        return status;
    }

    public FileStatusService.Status getStatus(Local local) {
        if (null == this.metadata.read(local, MetadataStorage.Key.metadata)) {
            if (!local.exists()) {
                return new FileStatusService.Status(FileStatusService.SyncState.unknown);
            }
            return new FileStatusService.Status(FileStatusService.SyncState.local);
        }
        if (null != this.metadata.read(local, MetadataStorage.Key.placeholder)) {
            return new FileStatusService.Status(FileStatusService.SyncState.placeholder);
        }
        return new FileStatusService.Status(FileStatusService.SyncState.synced);
    }
}

