/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.status;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.DefaultExceptionSerializer;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.SerializableOperationException;
import com.dd.plist.NSDictionary;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ErrorStatusService
implements FileStatusService {
    private static final Logger log = LogManager.getLogger((String)ErrorStatusService.class.getName());
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;

    public ErrorStatusService(LocalCache<?> cache, MetadataService<?> metadata) {
        this.cache = cache;
        this.metadata = metadata;
    }

    public FileStatusService.Status getStatus(Path file) {
        Local local = this.cache.toLocal(file);
        NSDictionary error = this.metadata.read(local, MetadataStorage.Key.error);
        if (null != error) {
            SerializableOperationException exception = new DefaultExceptionSerializer().deserialize(error);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return error status for file %s with failure %s", file, exception));
            }
            return new FileStatusService.Status(FileStatusService.SyncState.error, exception);
        }
        NSDictionary errors = this.metadata.read(this.cache.getDirectory(), MetadataStorage.Key.errors);
        if (null != errors) {
            HashSet<SerializableOperationException> exceptions = new HashSet<SerializableOperationException>();
            for (Map.Entry entry : errors.entrySet()) {
                SerializableOperationException exception = new DefaultExceptionSerializer().deserialize((NSDictionary)entry.getValue());
                Path remote = exception.getOperation().getRemote();
                if (!remote.isChild(file) || !this.cache.toLocal(file).exists()) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Return error status from list in metadata for file %s with failure %s", file, exception));
                }
                exceptions.add(exception);
            }
            if (!exceptions.isEmpty()) {
                return new FileStatusService.Status(FileStatusService.SyncState.error, exceptions);
            }
        }
        return new FileStatusService.Status(FileStatusService.SyncState.unknown);
    }
}

