/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.status;

import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChainedMountStatusService
implements FileStatusService {
    private static final Logger log = LogManager.getLogger((String)ChainedMountStatusService.class.getName());
    private final FileStatusService[] chain;

    public ChainedMountStatusService(FileStatusService ... status) {
        this.chain = status;
    }

    public FileStatusService.Status getStatus(Path file) {
        block3: for (FileStatusService service : this.chain) {
            FileStatusService.Status status = service.getStatus(file);
            switch (status.getState()) {
                case unknown: {
                    continue block3;
                }
                default: {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Return %s status for file %s determined by service %s", status, file, service));
                    }
                    return status;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return online status for file %s", file));
        }
        return new FileStatusService.Status(FileStatusService.SyncState.remote);
    }
}

