/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.status;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheExpiryStatusService
implements FileStatusService {
    private static final Logger log = LogManager.getLogger((String)CacheExpiryStatusService.class.getName());
    private final LocalCache<?> cache;
    private final MetadataService<?> metadataService;
    private final MetadataStorage.Key key;
    private long expiry;

    public CacheExpiryStatusService(MetadataStorage.Key key, LocalCache<?> cache, MetadataService<?> metadataService) {
        this.key = key;
        this.cache = cache;
        this.metadataService = metadataService;
        this.expiry = PreferencesFactory.get().getLong("fs.sync.cache.expire.ms");
    }

    public FileStatusService.Status getStatus(Path file) {
        if (-1L == this.expiry) {
            return new FileStatusService.Status(FileStatusService.SyncState.unknown);
        }
        Local local = this.cache.toLocal(file);
        long read = this.key.fromDictionary(this.metadataService.read(local, this.key));
        if (-1L == read) {
            log.warn(String.format("Missing key %s for file %s", this.key, file));
            return new FileStatusService.Status(FileStatusService.SyncState.unknown);
        }
        if (System.currentTimeMillis() - read >= this.expiry) {
            log.warn(String.format("Local cache expired for %s. Return status %s", file, FileStatusService.SyncState.remote));
            return new FileStatusService.Status(FileStatusService.SyncState.remote);
        }
        return new FileStatusService.Status(FileStatusService.SyncState.local);
    }

    public CacheExpiryStatusService withExpiry(long expiry) {
        this.expiry = expiry;
        return this;
    }
}

