/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.status;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.nio.LocalProtocol;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemIncrementalListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.option.SelectiveSyncOption;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import ch.iterate.mountainduck.sync.status.ErrorStatusService;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import ch.iterate.mountainduck.sync.status.SyncQueueStatusService;
import com.dd.plist.NSDictionary;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BadgeFileStatusService
implements FileStatusService {
    private static final Logger log = LogManager.getLogger((String)BadgeFileStatusService.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final LocalCache<?> cache;
    private final MetadataService<NSDictionary> metadata;
    private final ErrorStatusService errorStatusService;
    private final PlaceholderStatusService placeholderStatusService;
    private final SyncQueueStatusService queueStatusService;
    private final LRUCache<FilesystemCacheReference, FileStatusService.Status> badges = LRUCache.usingLoader(this::loadStatus, (long)PreferencesFactory.get().getLong("nativity.badge.cache.size"));

    public BadgeFileStatusService(SyncQueue queue, LocalCache<?> cache, MetadataService<NSDictionary> metadata) {
        this.cache = cache;
        this.metadata = metadata;
        this.errorStatusService = new ErrorStatusService(cache, metadata);
        this.placeholderStatusService = new PlaceholderStatusService(cache, metadata);
        this.queueStatusService = new SyncQueueStatusService(queue, cache, metadata);
    }

    public FileStatusService.Status reset(Path file, FileStatusService.Status status) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set status %s for file %s", status, file));
        }
        FileStatusService.Status previous = this.badges.contains((Object)new FilesystemCacheReference(file)) ? (FileStatusService.Status)this.badges.get((Object)new FilesystemCacheReference(file)) : new FileStatusService.Status(FileStatusService.SyncState.unknown);
        switch (status.getState()) {
            case unknown: {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Reset cached status for file %s", file));
                }
                this.badges.remove((Object)new FilesystemCacheReference(file));
                break;
            }
            default: {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Set cached status %s for file %s", status, file));
                }
                this.badges.put((Object)new FilesystemCacheReference(file), (Object)status);
            }
        }
        return previous;
    }

    public FileStatusService.Status getStatus(Path file) {
        FileStatusService.Status status = (FileStatusService.Status)this.badges.get((Object)new FilesystemCacheReference(file));
        if (log.isTraceEnabled()) {
            log.trace(String.format("Return status %s for file %s", status, file));
        }
        return status;
    }

    private FileStatusService.Status loadStatus(FilesystemCacheReference reference) {
        Path file = reference.getFile();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Load status for file %s", file));
        }
        FileStatusService.Status inqueue = this.queueStatusService.getStatus(file);
        switch (inqueue.getState()) {
            case inprogress: {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Return status %s for file %s", inqueue, file));
                }
                return inqueue;
            }
        }
        FileStatusService.Status err = this.errorStatusService.getStatus(file);
        switch (err.getState()) {
            case error: {
                Set failures = err.getExceptions();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Return status %s for file %s", err, file));
                }
                return new FileStatusService.Status(FileStatusService.SyncState.error, failures);
            }
        }
        Local local = this.cache.toLocal(file);
        FileStatusService.Status synced = this.placeholderStatusService.getStatus(local);
        switch (synced.getState()) {
            case unknown: 
            case ignored: 
            case local: {
                return synced;
            }
            case synced: {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Return status %s for file %s", synced, file));
                }
                if (this.cache.type(local).contains(AbstractPath.Type.directory) && this.preferences.getBoolean("nativity.badge.parent.refresh")) {
                    FileStatusService.Status recursive = this.getRecursively(file);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Return status %s for file %s", recursive, file));
                    }
                    return recursive;
                }
                return synced;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return status %s for file %s", FileStatusService.SyncState.remote, file));
        }
        return new FileStatusService.Status(FileStatusService.SyncState.remote);
    }

    protected FileStatusService.Status getRecursively(Path directory) {
        try {
            Path next;
            if (new SelectiveSyncOption(this.cache, this.metadata).include(directory)) {
                return new FileStatusService.Status(FileStatusService.SyncState.synced);
            }
            FilesystemIncrementalListProgressListener listener = new FilesystemIncrementalListProgressListener(new Host((Protocol)new LocalProtocol()));
            Worker worker = this.cache.list(directory, (FilesystemListProgressListener)listener, 0L);
            while ((next = listener.next()) != null) {
                FileStatusService.Status s = this.getStatus(next);
                switch (s.getState()) {
                    case inprogress: 
                    case error: 
                    case remote: {
                        worker.cancel();
                        return s;
                    }
                }
            }
        }
        catch (BackgroundException e) {
            log.error(String.format("Failure %s listing directory in cache", new Object[]{e}));
        }
        return new FileStatusService.Status(FileStatusService.SyncState.synced);
    }
}

