/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.quota;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.iterate.mountainduck.sync.cache.LocalCacheIndexer;
import ch.iterate.mountainduck.sync.indexer.PriorityCompletionService;
import ch.iterate.mountainduck.sync.indexer.TaskBackgroundAction;
import ch.iterate.mountainduck.sync.indexer.ThreadPoolPriorityCallable;
import ch.iterate.mountainduck.sync.quota.LocalCacheQuotaStrategy;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadedLocalCacheIndexer
implements LocalCacheIndexer {
    private static final Logger log = LogManager.getLogger((String)ThreadedLocalCacheIndexer.class.getName());
    private final ThreadPool pool;
    private final CompletionService<Void> completion;
    private final LocalCacheIndexer proxy;
    private final BackgroundActionRegistry registry;

    public ThreadedLocalCacheIndexer(LocalCacheIndexer proxy) {
        this(proxy, new BackgroundActionRegistry(), PreferencesFactory.get().getInteger("fs.sync.cache.indexer.pool.size"), ThreadPool.Priority.valueOf((String)PreferencesFactory.get().getProperty("fs.sync.cache.indexer.pool.priority")));
    }

    public ThreadedLocalCacheIndexer(LocalCacheIndexer proxy, BackgroundActionRegistry registry, int concurrency, ThreadPool.Priority priority) {
        this.proxy = proxy;
        this.registry = registry;
        this.pool = ThreadPoolFactory.get((String)"cache-indexer", (int)concurrency, (ThreadPool.Priority)priority, new PriorityBlockingQueue(concurrency), (Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler());
        this.completion = new PriorityCompletionService<Void>(this.pool.executor());
    }

    @Override
    public void index(final Path directory, final LocalCacheQuotaStrategy strategy, final ThreadPool.Priority priority) {
        ThreadPoolPriorityCallable task = new ThreadPoolPriorityCallable(priority, directory){

            @Override
            public Void call() {
                try {
                    ThreadedLocalCacheIndexer.this.proxy.index(directory, strategy, priority);
                    Void void_ = null;
                    return void_;
                }
                finally {
                    ThreadedLocalCacheIndexer.this.registry.remove((Object)new TaskBackgroundAction(this));
                }
            }
        };
        if (log.isDebugEnabled()) {
            log.debug(String.format("Index directory %s", directory));
        }
        this.submit(new TaskBackgroundAction(task));
    }

    @Override
    public void purge(final Path file) {
        ThreadPoolPriorityCallable task = new ThreadPoolPriorityCallable(ThreadPool.Priority.max, file){

            @Override
            public Void call() {
                try {
                    ThreadedLocalCacheIndexer.this.proxy.purge(file);
                    Void void_ = null;
                    return void_;
                }
                finally {
                    ThreadedLocalCacheIndexer.this.registry.remove((Object)new TaskBackgroundAction(this));
                }
            }
        };
        if (!this.registry.contains((Object)new TaskBackgroundAction(task))) {
            if (log.isInfoEnabled()) {
                log.debug(String.format("Purge file %s", file));
            }
            this.submit(new TaskBackgroundAction(task));
        }
    }

    @Override
    public void flush() {
        while (this.registry.size() > 0) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Await completion for %d submitted tasks in indexer", this.registry.size()));
            }
            try {
                Future<Void> future = this.completion.poll(1L, TimeUnit.SECONDS);
                if (null == future) continue;
                future.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn(String.format("Unhandled failure %s", e));
            }
            catch (TimeoutException timeoutException) {}
        }
    }

    protected Future<Void> submit(TaskBackgroundAction action) {
        this.registry.add((BackgroundAction)action);
        return this.completion.submit(action.getTask());
    }

    @Override
    public void shutdown() {
        for (BackgroundAction action : (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
            if (action == null) continue;
            action.cancel();
        }
        this.proxy.shutdown();
        this.pool.shutdown(false);
        this.registry.clear();
    }
}

