/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.quota;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.quota.LimitedTreeSet;
import ch.iterate.mountainduck.sync.quota.LocalCacheQuotaStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SizeLimitLocalCacheQuotaStrategy
implements LocalCacheQuotaStrategy {
    private static final Logger log = LogManager.getLogger((String)SizeLimitLocalCacheQuotaStrategy.class.getName());
    private final Collection<Path> candidates;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;
    private final long limit;
    private final AtomicLong size = new AtomicLong();

    public SizeLimitLocalCacheQuotaStrategy(LocalCache<?> cache, MetadataService<?> metadata) {
        this(PreferencesFactory.get().getLong("fs.sync.cache.indexer.strategy.size.limit"), PreferencesFactory.get().getLong("fs.sync.cache.indexer.strategy.chunksize"), cache, metadata);
    }

    public SizeLimitLocalCacheQuotaStrategy(long limit, long chunkSize, LocalCache<?> cache, MetadataService<?> metadata) {
        this.limit = limit;
        this.cache = cache;
        this.metadata = metadata;
        this.candidates = Collections.synchronizedCollection(new LimitedTreeSet<Path>(chunkSize, new FilesizeComparator()));
    }

    @Override
    public void visit(Path file) {
        if (file.attributes().getSize() > 0L) {
            this.size.addAndGet(file.attributes().getSize());
            if (this.candidates.add(file) && log.isDebugEnabled()) {
                log.debug(String.format("Adding %s to list of candidates", file));
            }
        }
    }

    @Override
    public AttributedList<Path> finish() {
        if (log.isInfoEnabled()) {
            log.info(String.format("Calculated cache size is %s with a limit of %d bytes", SizeFormatterFactory.get().format(this.size.get()), this.limit));
        }
        AttributedList result = new AttributedList();
        if (this.size.get() > this.limit) {
            List lru = this.candidates.stream().sorted((p1, p2) -> Long.compare(MetadataStorage.Key.lastaccess.fromDictionary(this.metadata.read(this.cache.toLocal(p1), MetadataStorage.Key.lastaccess)), MetadataStorage.Key.lastaccess.fromDictionary(this.metadata.read(this.cache.toLocal(p2), MetadataStorage.Key.lastaccess)))).collect(Collectors.toList());
            long tofreeup = this.size.get() - this.limit;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Collecting files to free up %s", SizeFormatterFactory.get().format(tofreeup)));
            }
            long freeup = 0L;
            for (Path p : lru) {
                result.add((Referenceable)p);
                if ((freeup += p.attributes().getSize()) <= tofreeup) continue;
                break;
            }
            if (log.isInfoEnabled()) {
                log.info(String.format("Collected %d files which will free up %s bytes", result.size(), SizeFormatterFactory.get().format(freeup)));
            }
        } else if (log.isInfoEnabled()) {
            log.info(String.format("No cache purging necessary with size %s and limit of %d", SizeFormatterFactory.get().format(this.size.get()), this.limit));
        }
        return result;
    }

    private static final class FilesizeComparator
    implements Comparator<Path> {
        private FilesizeComparator() {
        }

        @Override
        public int compare(Path p1, Path p2) {
            return -Long.compare(p1.attributes().getSize(), p2.attributes().getSize());
        }
    }
}

