/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.quota;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.NamedThreadFactory;
import ch.cyberduck.core.threading.ThreadPool;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.cache.LocalCacheIndexer;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.quota.ChainedLocalCacheQuotaStrategy;
import ch.iterate.mountainduck.sync.quota.LastAccessLocalCacheQuotaStrategy;
import ch.iterate.mountainduck.sync.quota.LocalCacheQuotaStrategy;
import ch.iterate.mountainduck.sync.quota.SizeLimitLocalCacheQuotaStrategy;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReschedulingLocalCacheQuotaIndexer
implements LocalCacheIndexer {
    private static final Logger log = LogManager.getLogger((String)ReschedulingLocalCacheQuotaIndexer.class.getName());
    private final LocalCacheIndexer proxy;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("quota-indexer-scheduler"));
    private final Preferences preferences = PreferencesFactory.get();
    private final PlaceholderStatusService status;

    public ReschedulingLocalCacheQuotaIndexer(LocalCacheIndexer proxy, LocalCache<?> cache, MetadataService<?> metadata) {
        this.proxy = proxy;
        this.cache = cache;
        this.metadata = metadata;
        this.status = new PlaceholderStatusService(cache, metadata);
    }

    @Override
    public void index(final Path directory, final LocalCacheQuotaStrategy strategy, final ThreadPool.Priority priority) {
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Run indexer %s for %s with strategy %s", ReschedulingLocalCacheQuotaIndexer.this.proxy, directory, strategy));
                }
                ArrayList<LocalCacheQuotaStrategy> strategies = new ArrayList<LocalCacheQuotaStrategy>();
                if (ReschedulingLocalCacheQuotaIndexer.this.preferences.getBoolean("fs.sync.cache.indexer.strategy.size.enable")) {
                    strategies.add(new SizeLimitLocalCacheQuotaStrategy(ReschedulingLocalCacheQuotaIndexer.this.cache, ReschedulingLocalCacheQuotaIndexer.this.metadata));
                }
                if (ReschedulingLocalCacheQuotaIndexer.this.preferences.getBoolean("fs.sync.cache.indexer.strategy.lru.enable")) {
                    strategies.add(new LastAccessLocalCacheQuotaStrategy(ReschedulingLocalCacheQuotaIndexer.this.cache, ReschedulingLocalCacheQuotaIndexer.this.metadata));
                }
                if (!strategies.isEmpty()) {
                    ChainedLocalCacheQuotaStrategy chain = new ChainedLocalCacheQuotaStrategy(strategies.toArray(new LocalCacheQuotaStrategy[0])){

                        @Override
                        public void visit(Path file) {
                            if (file.isDirectory()) {
                                return;
                            }
                            FileStatusService.Status state = ReschedulingLocalCacheQuotaIndexer.this.status.getStatus(file);
                            if (state.getState() == FileStatusService.SyncState.synced) {
                                super.visit(file);
                            } else {
                                log.warn(String.format("Skip evaluating %s with status %s", file, state));
                            }
                        }
                    };
                    ReschedulingLocalCacheQuotaIndexer.this.proxy.index(directory, chain, priority);
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Wait for indexer %s to complete indexing %s", ReschedulingLocalCacheQuotaIndexer.this.proxy, directory));
                    }
                    ReschedulingLocalCacheQuotaIndexer.this.proxy.flush();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Collect files from cache quota strategies %s", chain));
                    }
                    for (Path f : chain.finish()) {
                        ReschedulingLocalCacheQuotaIndexer.this.purge(f);
                    }
                } else if (log.isInfoEnabled()) {
                    log.info(String.format("Skip indexing as no strategy has been enabled", directory));
                }
                if (log.isInfoEnabled()) {
                    log.info(String.format("Reschedule indexing %s after flush", directory));
                }
            }
        }, 0L, this.preferences.getLong("fs.sync.cache.indexer.period.seconds"), TimeUnit.SECONDS);
    }

    @Override
    public void purge(Path file) {
        this.proxy.purge(file);
    }

    @Override
    public void flush() {
        this.proxy.flush();
    }

    @Override
    public void shutdown() {
        this.executor.shutdownNow();
        this.proxy.shutdown();
    }
}

